/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class RealmsClient$Environment extends Internal.Enum<Internal.RealmsClient$Environment> {
        static values(): Internal.RealmsClient$Environment[];
        static byName($$0: string): Internal.Optional<Internal.RealmsClient$Environment>;
        static valueOf($$0: string): Internal.RealmsClient$Environment;
        static readonly LOCAL: Internal.RealmsClient$Environment;
        baseUrl: string;
        static readonly PRODUCTION: Internal.RealmsClient$Environment;
        protocol: string;
        static readonly STAGE: Internal.RealmsClient$Environment;
    }
    type RealmsClient$Environment_ = "local" | "stage" | RealmsClient$Environment | "production";
    interface ClientPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(tag: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getCraftingGrid(): Internal.InventoryKJS;
        setXpLevel(l: number): void;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        setXp(xp: number): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(notification: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        isSelf(): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        abstract getData(): Internal.AttachedData<Internal.Player>;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get craftingGrid(): Internal.InventoryKJS
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get self(): boolean
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        (): Internal.AttachedData_<Internal.Player>;
    }
    type ClientPlayerKJS_ = ClientPlayerKJS;
    interface ProgressListener {
        abstract progressStart(arg0: net.minecraft.network.chat.Component_): void;
        abstract stop(): void;
        abstract progressStagePercentage(arg0: number): void;
        abstract progressStartNoAbort(arg0: net.minecraft.network.chat.Component_): void;
        abstract progressStage(arg0: net.minecraft.network.chat.Component_): void;
    }
    type ProgressListener_ = ProgressListener;
    class BeehiveBlockEntity$BeeReleaseStatus extends Internal.Enum<Internal.BeehiveBlockEntity$BeeReleaseStatus> {
        static values(): Internal.BeehiveBlockEntity$BeeReleaseStatus[];
        static valueOf($$0: string): Internal.BeehiveBlockEntity$BeeReleaseStatus;
        static readonly EMERGENCY: Internal.BeehiveBlockEntity$BeeReleaseStatus;
        static readonly HONEY_DELIVERED: Internal.BeehiveBlockEntity$BeeReleaseStatus;
        static readonly BEE_RELEASED: Internal.BeehiveBlockEntity$BeeReleaseStatus;
    }
    type BeehiveBlockEntity$BeeReleaseStatus_ = "bee_released" | "honey_delivered" | BeehiveBlockEntity$BeeReleaseStatus | "emergency";
    class FlowerBlockBOP extends Internal.FlowerBlock {
        constructor(effect: Internal.MobEffect_, effectDuration: number, properties: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static tryGet($$0: Internal.ItemLike_): Internal.SuspiciousEffectHolder;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static getAllEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get allEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>
    }
    type FlowerBlockBOP_ = FlowerBlockBOP;
    class SignableCommand <S> extends Internal.Record {
        constructor($$0: Internal.List_<Internal.SignableCommand$Argument<S>>)
        static of<S>($$0: Internal.ParseResults_<S>): Internal.SignableCommand<S>;
        "arguments"(): Internal.List<Internal.SignableCommand$Argument<S>>;
    }
    type SignableCommand_<S> = SignableCommand<S>;
    class SemaphoreItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SemaphoreItem_ = SemaphoreItem;
    interface NoiseProviderAccessor {
        abstract getStates(): Internal.List<Internal.BlockState>;
        get states(): Internal.List<Internal.BlockState>
        (): Internal.List_<Internal.BlockState>;
    }
    type NoiseProviderAccessor_ = NoiseProviderAccessor;
    class ImmutableCollections$List12 <E> extends Internal.ImmutableCollections$AbstractImmutableList<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        get(arg0: number): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        getFirst(): E;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        get last(): E
        get first(): E
    }
    type ImmutableCollections$List12_<E> = ImmutableCollections$List12<E>;
    class WildRiceBlock extends Internal.DoublePlantBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluidIn: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess(level: Internal.Level_, rand: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(level: Internal.ServerLevel_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(level: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type WildRiceBlock_ = WildRiceBlock;
    class NarratedElementType extends Internal.Enum<Internal.NarratedElementType> {
        static valueOf($$0: string): Internal.NarratedElementType;
        static values(): Internal.NarratedElementType[];
        static readonly HINT: Internal.NarratedElementType;
        static readonly POSITION: Internal.NarratedElementType;
        static readonly TITLE: Internal.NarratedElementType;
        static readonly USAGE: Internal.NarratedElementType;
    }
    type NarratedElementType_ = NarratedElementType | "hint" | "position" | "title" | "usage";
    class TrackGraphLocation {
        constructor()
        position: number;
        graph: Internal.TrackGraph;
        edge: Internal.Couple<Internal.TrackNodeLocation>;
    }
    type TrackGraphLocation_ = TrackGraphLocation;
    abstract class SimpleChannelInboundHandler <I> extends Internal.ChannelInboundHandlerAdapter {
        acceptInboundMessage(arg0: any): boolean;
    }
    type SimpleChannelInboundHandler_<I> = SimpleChannelInboundHandler<I>;
    interface BlockCachingEntity {
        abstract getCachedFeetBlockState(): Internal.BlockState;
        lithiumOnBlockCacheDeleted(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        get cachedFeetBlockState(): Internal.BlockState
        (): Internal.BlockState_;
    }
    type BlockCachingEntity_ = BlockCachingEntity;
    class DoorControlBehaviour extends Internal.BlockEntityBehaviour {
        constructor(be: Internal.SmartBlockEntity_)
        set(mode: Internal.DoorControl_): void;
        static readonly TYPE: Internal.BehaviourType<Internal.DoorControlBehaviour>;
        mode: Internal.DoorControl;
    }
    type DoorControlBehaviour_ = DoorControlBehaviour;
    interface ICraftingCPU {
        abstract getSelectionMode(): Internal.CpuSelectionMode;
        abstract isBusy(): boolean;
        abstract getName(): net.minecraft.network.chat.Component;
        abstract cancelJob(): void;
        abstract getCoProcessors(): number;
        abstract getJobStatus(): Internal.CraftingJobStatus;
        abstract getAvailableStorage(): number;
        get selectionMode(): Internal.CpuSelectionMode
        get busy(): boolean
        get name(): net.minecraft.network.chat.Component
        get coProcessors(): number
        get jobStatus(): Internal.CraftingJobStatus
        get availableStorage(): number
    }
    type ICraftingCPU_ = ICraftingCPU;
    abstract class AbstractEnergyStorage <C extends Internal.IEnergyConfig<owmii.powah.block.Tier>, B extends Internal.AbstractEnergyBlock<C, B>> extends Internal.AbstractTickableTile<owmii.powah.block.Tier, B> implements Internal.IRedstoneInteract {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_, variant: owmii.powah.block.Tier_)
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        readSync(nbt: Internal.CompoundTag_): void;
        writeSync(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        canReceiveEnergy(side: Internal.Direction_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        receiveEnergy(maxReceive: number, simulate: boolean, side: Internal.Direction_): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        canExtractEnergy(side: Internal.Direction_): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getSideConfig(): Internal.SideConfig;
        keepEnergy(): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getEnergy(): Internal.Energy;
        invalidateCaps(): void;
        isEnergyPresent(side: Internal.Direction_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getTransferType(): Internal.Transfer;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        nextRedstoneMode(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        extractEnergy(maxExtract: number, simulate: boolean, side: Internal.Direction_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get sideConfig(): Internal.SideConfig
        get energy(): Internal.Energy
        get transferType(): Internal.Transfer
    }
    type AbstractEnergyStorage_<C extends Internal.IEnergyConfig<owmii.powah.block.Tier>, B extends Internal.AbstractEnergyBlock<C, B>> = AbstractEnergyStorage<C, B>;
    class PBRSpriteHolder {
        constructor()
        getNormalSprite(): Internal.TextureAtlasSprite;
        close(): void;
        setNormalSprite(sprite: Internal.TextureAtlasSprite_): void;
        setSpecularSprite(sprite: Internal.TextureAtlasSprite_): void;
        getSpecularSprite(): Internal.TextureAtlasSprite;
        get normalSprite(): Internal.TextureAtlasSprite
        set normalSprite(sprite: Internal.TextureAtlasSprite_)
        set specularSprite(sprite: Internal.TextureAtlasSprite_)
        get specularSprite(): Internal.TextureAtlasSprite
    }
    type PBRSpriteHolder_ = PBRSpriteHolder;
    interface IComponentProcessor {
        refresh(parent: Internal.Screen_, left: number, top: number): void;
        allowRender(group: string): boolean;
        abstract process(arg0: Internal.Level_, arg1: string): Internal.IVariable;
        abstract setup(arg0: Internal.Level_, arg1: Internal.IVariableProvider_): void;
    }
    type IComponentProcessor_ = IComponentProcessor;
    class ConnectedPillarBlock extends Internal.LayeredBlock {
        constructor(p_55926_: Internal.BlockBehaviour$Properties_)
        static setConnection(state: Internal.BlockState_, side: Internal.Direction_, connect: boolean): Internal.BlockState;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static connection(axis: Internal.Direction$Axis_, side: Internal.Direction_): Internal.BooleanProperty;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getConnection(state: Internal.BlockState_, side: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type ConnectedPillarBlock_ = ConnectedPillarBlock;
    abstract class CustomRecipe implements Internal.CraftingRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        abstract matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        abstract assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        setGroup(group: string): void;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type CustomRecipe_ = CustomRecipe;
    class DensityFunctions$Clamp extends Internal.Record implements Internal.DensityFunctions$PureTransformer {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        transform($$0: number): number;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
        input(): Internal.DensityFunction;
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunctions$Clamp>;
    }
    type DensityFunctions$Clamp_ = DensityFunctions$Clamp;
    class TrackSwitchBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity, Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        isReverseRight(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTargetAnalogOutput(): number;
        isReverseLeft(): boolean;
        onLoad(): void;
        getSwitch(): Internal.TrackSwitch;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        isAutomatic(): boolean;
        isNormal(): boolean;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLocked(): boolean;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        hasExit(state: Internal.TrackSwitchBlock$SwitchState_): boolean;
        getState(): Internal.TrackSwitchBlock$SwitchState;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(blockEntity: Internal.BlockEntity_, structureTransform: Internal.StructureTransform_): void;
        clientLazyTick(): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        setStatePonder(state: Internal.TrackSwitchBlock$SwitchState_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getOverlayModel(): Internal.PartialModel;
        get reverseRight(): boolean
        get targetAnalogOutput(): number
        get reverseLeft(): boolean
        get "switch"(): Internal.TrackSwitch
        get automatic(): boolean
        get normal(): boolean
        get locked(): boolean
        get infiniteBoundingBox(): Internal.AABB
        get state(): Internal.TrackSwitchBlock$SwitchState
        set statePonder(state: Internal.TrackSwitchBlock$SwitchState_)
        get overlayModel(): Internal.PartialModel
        edgePoint: Internal.TrackTargetingBehaviour<Internal.TrackSwitch>;
        ponderData: Internal.TrackSwitchBlockEntity$PonderData;
    }
    type TrackSwitchBlockEntity_ = TrackSwitchBlockEntity;
    interface FluidBlockAccessor {
        callInit(fluid: Internal.FlowingFluid_, settings: Internal.BlockBehaviour$Properties_): Internal.LiquidBlock;
    }
    type FluidBlockAccessor_ = FluidBlockAccessor;
    class MutablePair <L, R> extends org.apache.commons.lang3.tuple.Pair<L, R> {
        constructor()
        constructor(arg0: L, arg1: R)
        static comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        getLeft(): L;
        static of<L, R>(arg0: L, arg1: R): Internal.MutablePair<L, R>;
        getRight(): R;
        static emptyArray<L, R>(): Internal.MutablePair<L, R>[];
        static comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        static copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        static of<L, R>(arg0: Internal.Map$Entry_<L, R>): Internal.MutablePair<L, R>;
        static comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        setRight(arg0: R): void;
        static comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        setLeft(arg0: L): void;
        setValue(arg0: R): R;
        get left(): L
        get right(): R
        set right(arg0: R)
        set left(arg0: L)
        set value(arg0: R)
        left: L;
        right: R;
        static readonly EMPTY_ARRAY: Internal.MutablePair<any, any>[];
    }
    type MutablePair_<L, R> = MutablePair<L, R>;
    abstract class IntProvider {
        constructor()
        abstract getMinValue(): number;
        abstract getType(): Internal.IntProviderType<any>;
        abstract sample(arg0: Internal.RandomSource_): number;
        abstract getMaxValue(): number;
        static codec($$0: number, $$1: number): Internal.Codec<Internal.IntProvider>;
        static codec<T extends Internal.IntProvider>($$0: number, $$1: number, $$2: Internal.Codec_<T>): Internal.Codec<T>;
        get minValue(): number
        get type(): Internal.IntProviderType<any>
        get maxValue(): number
        static readonly CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly NON_NEGATIVE_CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly POSITIVE_CODEC: Internal.Codec<Internal.IntProvider>;
    }
    type IntProvider_ = {clamped: any_, min: number, max: number} | {value: number, clamped: any_} | number | {max_inclusive: number, clamped_normal: any_, mean: number, deviation: number, min_inclusive: number} | {clamped_normal: any_, mean: number, deviation: number, value: number} | IntProvider | {clamped_normal: any_, mean: number, deviation: number, bounds: [number, number]} | {clamped: any_, bounds: [number, number]} | {max_inclusive: number, clamped: any_, min_inclusive: number} | {clamped_normal: any_, mean: number, deviation: number, min: number, max: number} | [number, number];
    class WirelessModemBlock extends Internal.DirectionalBlock implements Internal.SimpleWaterloggedBlock, Internal.EntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_, type: any_<Internal.BlockEntityType<any>>)
        newBlockEntity(blockPos: BlockPos_, blockState: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly ON: Internal.BooleanProperty;
    }
    type WirelessModemBlock_ = WirelessModemBlock;
    class BrainDebugRenderer$PoiInfo {
        constructor($$0: BlockPos_, $$1: string, $$2: number)
        type: string;
        readonly pos: BlockPos;
        freeTicketCount: number;
    }
    type BrainDebugRenderer$PoiInfo_ = BrainDebugRenderer$PoiInfo;
    interface BlockItemExtensions {
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
    }
    type BlockItemExtensions_ = BlockItemExtensions;
    class Method extends Internal.Executable {
        getReturnType(): typeof any;
        getDefaultValue(): any;
        isBridge(): boolean;
        getGenericReturnType(): Internal.Type;
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getTypeParameters(): any[];
        invoke(arg0: any, ...arg1: any[]): any;
        isDefault(): boolean;
        get returnType(): typeof any
        get defaultValue(): any
        get bridge(): boolean
        get genericReturnType(): Internal.Type
        get typeParameters(): any[]
        get "default"(): boolean
    }
    type Method_ = Method;
    class FluidAmountDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type FluidAmountDisplaySource_ = FluidAmountDisplaySource;
    class ImmutableCollections$SetN <E> extends Internal.ImmutableCollections$AbstractImmutableSet<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
    }
    type ImmutableCollections$SetN_<E> = ImmutableCollections$SetN<E>;
    interface CustomIngredientActionCallback {
        abstract transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.InventoryKJS_): Internal.ItemStack;
        (arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS): Internal.ItemStack_;
    }
    type CustomIngredientActionCallback_ = CustomIngredientActionCallback;
    class DisplaySide extends Internal.Enum<Internal.DisplaySide> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        next(): this;
        static values(): Internal.DisplaySide[];
        static valueOf(name: string): Internal.DisplaySide;
        static fromName(name: string): Internal.DisplaySide;
        previous(): this;
        get serializedName(): string
        static readonly FRONT: Internal.DisplaySide;
        static readonly LEFT: Internal.DisplaySide;
        static readonly RIGHT: Internal.DisplaySide;
    }
    type DisplaySide_ = "front" | "right" | DisplaySide | "left";
    class VersionedInventoryTrackerBehaviour extends Internal.BlockEntityBehaviour {
        constructor(be: Internal.SmartBlockEntity_)
        awaitNewVersion(behaviour: Internal.InvManipulationBehaviour_): void;
        stillWaiting(behaviour: Internal.InvManipulationBehaviour_): boolean;
        awaitNewVersion(handler: Internal.Storage_<Internal.ItemVariant>): void;
        reset(): void;
        stillWaiting(handler: Internal.Storage_<Internal.ItemVariant>): boolean;
        static readonly TYPE: Internal.BehaviourType<Internal.VersionedInventoryTrackerBehaviour>;
    }
    type VersionedInventoryTrackerBehaviour_ = VersionedInventoryTrackerBehaviour;
    class Locale$LanguageRange {
        constructor(arg0: string, arg1: number)
        constructor(arg0: string)
        getWeight(): number;
        static parse(arg0: string): Internal.List<Internal.Locale$LanguageRange>;
        static parse(arg0: string, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        static mapEquivalents(arg0: Internal.List_<Internal.Locale$LanguageRange>, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        getRange(): string;
        get weight(): number
        get range(): string
        static readonly MAX_WEIGHT: 1.0;
        static readonly MIN_WEIGHT: 0.0;
    }
    type Locale$LanguageRange_ = Locale$LanguageRange;
    interface ArgumentType <T> {
        abstract parse(arg0: Internal.StringReader_): T;
        getExamples(): Internal.Collection<string>;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        get examples(): Internal.Collection<string>
        (arg0: Internal.StringReader): T;
    }
    type ArgumentType_<T> = ArgumentType<T>;
    class ItemCooldowns implements Internal.AccessorItemCooldowns {
        constructor()
        addCooldown($$0: Internal.Item_, $$1: number): void;
        bookshelf$getTickCount(): number;
        bookshelf$getCooldowns(): Internal.Map<any, any>;
        getCooldownPercent($$0: Internal.Item_, $$1: number): number;
        isOnCooldown($$0: Internal.Item_): boolean;
        removeCooldown($$0: Internal.Item_): void;
        tick(): void;
    }
    type ItemCooldowns_ = ItemCooldowns;
    class StonecutterRecipe extends Internal.SingleItemRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.Ingredient_, $$3: Internal.ItemStack_)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type StonecutterRecipe_ = StonecutterRecipe;
    class DataPackEventJS extends Internal.EventJS {
        constructor(d: any_, rm: any_)
        add(id: ResourceLocation_, content: string): void;
        addJson(id: ResourceLocation_, json: Internal.JsonElement_): void;
    }
    type DataPackEventJS_ = DataPackEventJS;
    abstract class HorizontalAxisKineticBlock extends Internal.KineticBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static getPreferredHorizontalAxis(context: Internal.BlockPlaceContext_): Internal.Direction$Axis;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly HORIZONTAL_AXIS: Internal.Property<Internal.Direction$Axis>;
    }
    type HorizontalAxisKineticBlock_ = HorizontalAxisKineticBlock;
    class MechanicalPistonBlock extends Internal.DirectionalAxisKineticBlock implements Internal.IBE<Internal.MechanicalPistonBlockEntity> {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        static isStickyPiston(state: Internal.BlockState_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.MechanicalPistonBlockEntity>): void;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.MechanicalPistonBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityClass(): typeof Internal.MechanicalPistonBlockEntity;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static maxAllowedPistonPoles(): number;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.MechanicalPistonBlockEntity>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.MechanicalPistonBlockEntity>;
        static isPistonHead(state: Internal.BlockState_): boolean;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        static sticky(properties: Internal.BlockBehaviour$Properties_): Internal.MechanicalPistonBlock;
        static isPiston(state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.MechanicalPistonBlockEntity;
        static normal(properties: Internal.BlockBehaviour$Properties_): Internal.MechanicalPistonBlock;
        static isExtensionPole(state: Internal.BlockState_): boolean;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.MechanicalPistonBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.MechanicalPistonBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly STATE: Internal.EnumProperty<Internal.MechanicalPistonBlock$PistonState>;
    }
    type MechanicalPistonBlock_ = MechanicalPistonBlock;
    class ChainBuffer {
        constructor()
        applyChainWaveBuffer(...boxes: any_[]): void;
        calculateChainWaveBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, entity: Internal.LivingEntity_): void;
        calculateChainSwingBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, entity: Internal.LivingEntity_): void;
        applyChainSwingBuffer(...boxes: any_[]): void;
        resetRotations(): void;
        calculateChainWaveBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, divisor: number, entity: Internal.LivingEntity_): void;
        calculateChainSwingBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, divisor: number, entity: Internal.LivingEntity_): void;
    }
    type ChainBuffer_ = ChainBuffer;
    class DoorControl extends Internal.Enum<Internal.DoorControl> {
        static valueOf(name: string): Internal.DoorControl;
        matches(doorDirection: Internal.Direction_): boolean;
        static createWidget(x: number, y: number, callback: Internal.Consumer_<Internal.DoorControl>, initial: Internal.DoorControl_): net.createmod.catnip.data.Pair<Internal.ScrollInput, Internal.Label>;
        static values(): Internal.DoorControl[];
        static readonly SOUTH: Internal.DoorControl;
        static readonly NONE: Internal.DoorControl;
        static readonly WEST: Internal.DoorControl;
        static readonly ALL: Internal.DoorControl;
        static readonly NORTH: Internal.DoorControl;
        static readonly EAST: Internal.DoorControl;
    }
    type DoorControl_ = "west" | "east" | "south" | "north" | DoorControl | "none" | "all";
    class LanternBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly HANGING: Internal.BooleanProperty;
    }
    type LanternBlock_ = LanternBlock;
    interface Tier extends Internal.TierMixin, Internal.TierExtensions {
        abstract getLevel(): number;
        abstract getAttackDamageBonus(): number;
        abstract getRepairIngredient(): Internal.Ingredient;
        abstract getEnchantmentValue(): number;
        abstract getUses(): number;
        abstract getSpeed(): number;
        getTag(): Internal.TagKey<Internal.Block>;
        get level(): number
        get attackDamageBonus(): number
        get repairIngredient(): Internal.Ingredient
        get enchantmentValue(): number
        get uses(): number
        get speed(): number
        get tag(): Internal.TagKey<Internal.Block>
    }
    type Tier_ = string | Tier;
    class SporeBlossomBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SporeBlossomBlock_ = SporeBlossomBlock;
    class PostPass implements Internal.AutoCloseable {
        constructor($$0: Internal.ResourceManager_, $$1: string, $$2: Internal.RenderTarget_, $$3: Internal.RenderTarget_)
        setOrthoMatrix($$0: Matrix4f_): void;
        process($$0: number): void;
        close(): void;
        getName(): string;
        getEffect(): Internal.EffectInstance;
        addAuxAsset($$0: string, $$1: Internal.IntSupplier_, $$2: number, $$3: number): void;
        set orthoMatrix($$0: Matrix4f_)
        get name(): string
        get effect(): Internal.EffectInstance
        readonly outTarget: Internal.RenderTarget;
        readonly inTarget: Internal.RenderTarget;
    }
    type PostPass_ = PostPass;
    interface AnimationController$SoundKeyframeHandler <A extends Internal.GeoAnimatable> {
        abstract handle(arg0: Internal.SoundKeyframeEvent_<A>): void;
        (arg0: Internal.SoundKeyframeEvent<A>): void;
    }
    type AnimationController$SoundKeyframeHandler_<A extends Internal.GeoAnimatable> = AnimationController$SoundKeyframeHandler<A>;
    class ClientboundTagQueryPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.CompoundTag_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getTransactionId(): number;
        getTag(): Internal.CompoundTag;
        isSkippable(): boolean;
        get transactionId(): number
        get tag(): Internal.CompoundTag
        get skippable(): boolean
    }
    type ClientboundTagQueryPacket_ = ClientboundTagQueryPacket;
    interface BufferedImageOp {
        abstract createCompatibleDestImage(arg0: Internal.BufferedImage_, arg1: Internal.ColorModel_): Internal.BufferedImage;
        abstract filter(arg0: Internal.BufferedImage_, arg1: Internal.BufferedImage_): Internal.BufferedImage;
        abstract getBounds2D(arg0: Internal.BufferedImage_): Internal.Rectangle2D;
        abstract getPoint2D(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        abstract getRenderingHints(): Internal.RenderingHints;
        get renderingHints(): Internal.RenderingHints
    }
    type BufferedImageOp_ = BufferedImageOp;
    interface LandPathNodeTypesRegistry$StaticPathNodeTypeProvider extends Internal.LandPathNodeTypesRegistry$PathNodeTypeProvider {
        abstract getPathNodeType(arg0: Internal.BlockState_, arg1: boolean): Internal.BlockPathTypes;
        (arg0: Internal.BlockState, arg1: boolean): Internal.BlockPathTypes_;
    }
    type LandPathNodeTypesRegistry$StaticPathNodeTypeProvider_ = LandPathNodeTypesRegistry$StaticPathNodeTypeProvider;
    class HitResult$Type extends Internal.Enum<Internal.HitResult$Type> {
        static valueOf($$0: string): Internal.HitResult$Type;
        static values(): Internal.HitResult$Type[];
        static readonly MISS: Internal.HitResult$Type;
        static readonly ENTITY: Internal.HitResult$Type;
        static readonly BLOCK: Internal.HitResult$Type;
    }
    type HitResult$Type_ = "miss" | "block" | HitResult$Type | "entity";
    interface ScreenMouseEvents$AfterMouseScroll {
        abstract afterMouseScroll(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number, arg4: number): void;
    }
    type ScreenMouseEvents$AfterMouseScroll_ = ScreenMouseEvents$AfterMouseScroll;
    class SynchedEntityData$DataValue <T> extends Internal.Record {
        constructor($$0: number, $$1: Internal.EntityDataSerializer_<T>, $$2: T)
        write($$0: Internal.FriendlyByteBuf_): void;
        id(): number;
        serializer(): Internal.EntityDataSerializer<T>;
        static create<T>($$0: Internal.EntityDataAccessor_<T>, $$1: T): Internal.SynchedEntityData$DataValue<T>;
        static read($$0: Internal.FriendlyByteBuf_, $$1: number): Internal.SynchedEntityData$DataValue<any>;
        value(): T;
    }
    type SynchedEntityData$DataValue_<T> = SynchedEntityData$DataValue<T>;
    abstract class ImmutableList <E> extends Internal.ImmutableCollection<E> implements Internal.RandomAccess, Internal.List<E> {
        static builder<E>(): Internal.ImmutableList$Builder<E>;
        addLast(arg0: E): void;
        getLast(): E;
        static copyOf<E>(arg0: E[]): Internal.ImmutableList<E>;
        reverse(): this;
        static sortedCopyOf<E>(arg0: Internal.Comparator_<E>, arg1: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<E>): void;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        /**
         * @deprecated
        */
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        listIterator(): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableList<E>;
        indexOf(arg0: any): number;
        addFirst(arg0: E): void;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: E): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableList<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.ImmutableList<E>;
        stream(): Internal.Stream<E>;
        removeLast(): E;
        iterator(): Internal.UnmodifiableIterator<E>;
        lastIndexOf(arg0: any): number;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableList<E>;
        abstract get(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        removeFirst(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.ImmutableList<E>;
        parallelStream(): Internal.Stream<E>;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E, arg11: E, ...arg12: E[]): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.ImmutableList<E>;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableList$Builder<E>;
        static of<E>(): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        remove(arg0: number): E;
        static of<E>(arg0: E): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.ImmutableList<E>;
        static sortedCopyOf<E extends Internal.Comparable<any>>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        asList(): this;
        getFirst(): E;
        subList(arg0: number, arg1: number): Internal.List<any>;
        static toImmutableList<E>(): Internal.Collector<E, any, Internal.ImmutableList<E>>;
        spliterator(): Internal.Spliterator<E>;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableList<E>;
        get last(): E
        get first(): E
    }
    type ImmutableList_<E> = ImmutableList<E>;
    /**
     * Methods for working with Java classes. Reflection my beloved ♥
    */
    class JavaWrapper {
        constructor(manager: any_)
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerScoreboard$Method"): typeof Internal.ServerScoreboard$Method;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.controller.TinyMultiblockControllerBlock"): typeof Internal.TinyMultiblockControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.FlavorMap"): Internal.FlavorMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.Consumer"): Internal.Consumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.tropheusj.milk.MilkFluid$Flowing"): typeof Internal.MilkFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.item.MediaHolderItem"): Internal.MediaHolderItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe"): typeof Internal.SeveringRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SimpleFoiledItem"): typeof Internal.SimpleFoiledItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.ratatouille.mixin.client.BlockRenderManagerAccessor"): Internal.BlockRenderManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.roller.RollerBlockEntity"): typeof Internal.RollerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientAdvancements"): typeof Internal.ClientAdvancements;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "glitchcore.fabric.gui.IExtendedGuiGraphics"): Internal.IExtendedGuiGraphics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockStateExtensions"): io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockStateExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.entity.pushable.EntityPushablePredicate"): typeof Internal.EntityPushablePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket"): typeof Internal.ClientboundLevelChunkWithLightPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.targeting.TargetingConditions"): typeof Internal.TargetingConditions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity"): typeof Internal.PortableEnergyInterfaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.TrackBlockItem"): typeof Internal.TrackBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceRules$RuleSource"): Internal.SurfaceRules$RuleSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Provider"): typeof Internal.Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.EntityVisual"): Internal.EntityVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket"): typeof Internal.ServerboundPlayerCommandPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPartModel"): Internal.IPartModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.CursorType"): typeof Internal.CursorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.processing.FanProcessingType$AirFlowParticleAccess"): Internal.FanProcessingType$AirFlowParticleAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.RiceBlock"): typeof Internal.RiceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.InputReplacement"): Internal.InputReplacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap$FastSortedEntrySet"): Internal.Long2ObjectSortedMap$FastSortedEntrySet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_tracks.generic_crossing.TrackShapeLookup$GenericCrossingData"): typeof Internal.TrackShapeLookup$GenericCrossingData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.vertex.VertexList"): Internal.VertexList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.registry.fluid.BotariumFlowingFluid"): typeof Internal.BotariumFlowingFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.MushroomBlockBOP"): typeof Internal.MushroomBlockBOP;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.stacks.AmountFormat"): typeof Internal.AmountFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket"): typeof Internal.ClientboundSetBorderWarningDelayPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.data.ParticleKeyframeData"): typeof Internal.ParticleKeyframeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.BaseMapCodec"): Internal.BaseMapCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ScoreHolderArgument$Info"): typeof Internal.ScoreHolderArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerScoreboard"): typeof Internal.ServerScoreboard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2FloatFunction"): Internal.Long2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.SafetyNetBlock"): typeof Internal.SafetyNetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.pneumono.gravestones.block.AestheticGravestoneBlockEntity"): typeof Internal.AestheticGravestoneBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.stages.StageChangeEvent"): typeof Internal.StageChangeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriSoilCondition$Acidity"): typeof Internal.AgriSoilCondition$Acidity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.BiPredicate"): Internal.BiPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.Vec2"): typeof Internal.Vec2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.PatternContainerGroup"): typeof Internal.PatternContainerGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.pigment.ItemPridePigment$Type"): typeof Internal.ItemPridePigment$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.BaseRailBlockExtensions"): Internal.BaseRailBlockExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint"): typeof Internal.SingleBlockEntityEdgePoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.spatial.SpatialAnchorBlock"): typeof Internal.SpatialAnchorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2LongFunction"): Internal.Double2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.EntityArgument$Info"): typeof Internal.EntityArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$Marker$Type"): typeof Internal.DensityFunctions$Marker$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.ResourceManagerReloadListener"): Internal.ResourceManagerReloadListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.ServerGamePacketListenerImplAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.ServerGamePacketListenerImplAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Locale$FilteringMode"): typeof Internal.Locale$FilteringMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.StringReader"): typeof Internal.StringReader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.PortableCellItem"): typeof Internal.PortableCellItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.energy.InternalEnergyStorage"): typeof Internal.InternalEnergyStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity"): typeof Internal.TableClothBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.RandomSequences"): typeof Internal.RandomSequences;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.math.OctahedralGroup"): typeof Internal.OctahedralGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.syncher.EntityDataAccessor"): typeof Internal.EntityDataAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.WardenEntitySensor"): typeof Internal.WardenEntitySensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.PlayerEventJS"): typeof Internal.PlayerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.ItemToolTierRegistryEventJS"): typeof Internal.ItemToolTierRegistryEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.material.IMaterialValue"): Internal.IMaterialValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.BaseImmutableMultimap"): typeof Internal.BaseImmutableMultimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.BelowZeroRetrogen"): typeof Internal.BelowZeroRetrogen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.UserWhiteList"): typeof Internal.UserWhiteList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.goat.Goat"): typeof Internal.Goat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.DefaultedRegistry"): Internal.DefaultedRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation"): Internal.ILimitedGlobalStation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapDecoder"): Internal.MapDecoder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity"): typeof Internal.AbstractBogeyBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Vector"): typeof Internal.Vector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer"): typeof Internal.SimpleCraftingRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.symmetryWand.SymmetryWandItem"): typeof Internal.SymmetryWandItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.mixin.ui.access.BlockEntityAccessor"): io.wispforest.owo.mixin.ui.access.BlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.material.MaterialRecipe"): typeof Internal.MaterialRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity$ComputerSignal$TubeDisplay"): typeof Internal.NixieTubeBlockEntity$ComputerSignal$TubeDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.placard.PlacardBlock"): typeof Internal.PlacardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.feet.KittySlippersItem"): typeof Internal.KittySlippersItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ServerLevelAccessor"): Internal.ServerLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.TimeUnit"): typeof Internal.TimeUnit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe$Serializer"): typeof Internal.ItemCastingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetScorePacket"): typeof Internal.ClientboundSetScorePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.LayeredRegistryAccess"): typeof Internal.LayeredRegistryAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.gui.chest.ChestMenuData"): typeof Internal.ChestMenuData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.BlockHitResult"): typeof Internal.BlockHitResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeSerializer"): typeof Internal.ToolBuildingRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel$Builder"): typeof Internal.ConfiguredModel$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.AbstractHurtingProjectile"): typeof Internal.AbstractHurtingProjectile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.client.multiplayer.AccessorClientAdvancements"): Internal.AccessorClientAdvancements;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBundlePacket"): typeof Internal.ClientboundBundlePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity$AllowedOperationMode"): typeof Internal.TrackCouplerBlockEntity$AllowedOperationMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.mesh.Mesh"): net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.AbstractWidget"): typeof Internal.AbstractWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents$NewLightingStrike"): Internal.EntityEvents$NewLightingStrike;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LiquidBlockAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LiquidBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.math.HexCoord$Companion"): typeof Internal.HexCoord$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.Component$DismountReason"): typeof Internal.Component$DismountReason;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.item.LoreBlockItem"): typeof Internal.LoreBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.JaggedSandstoneFeature"): typeof Internal.JaggedSandstoneFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper"): typeof Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.armor.ItemScaleArmor"): typeof Internal.ItemScaleArmor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragGestureListener"): Internal.DragGestureListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "virtuoel.pehkui.util.NbtCompoundExtensions"): Internal.NbtCompoundExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedBlockExtension"): Internal.InjectedBlockExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.StringSplitter"): typeof Internal.StringSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.StatTrackingDisplaySource"): typeof Internal.StatTrackingDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest"): typeof Internal.AxisAlignedLinearPosTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.Aquifer$FluidStatus"): typeof Internal.Aquifer$FluidStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.AbsoptionMobEffect"): typeof Internal.AbsoptionMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleSelection"): Internal.AccessibleSelection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$DoubleValue"): typeof Internal.ForgeConfigSpec$DoubleValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo"): typeof Internal.IntegerArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MultifaceSpreader"): typeof Internal.MultifaceSpreader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.mixin.accessor.HoeItemAccessor"): Internal.HoeItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriFluidCondition"): typeof Internal.AgriFluidCondition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker"): Internal.ComparatorTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.fabric.ServerGamePacketListenerImplAccessor"): Internal.ServerGamePacketListenerImplAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Biome$Precipitation"): typeof Internal.Biome$Precipitation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexBuffer"): typeof Internal.VertexBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DragonEggBlock"): typeof Internal.DragonEggBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.clipboard.ClipboardBlock"): typeof Internal.ClipboardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.data.DragonArmorPart"): typeof Internal.DragonArmorPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.RiceBaleBlock"): typeof Internal.RiceBaleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation"): Internal.IHaveHoveringInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.math.HexPattern$Companion"): typeof Internal.HexPattern$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlock"): typeof Internal.ChainConveyorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator"): typeof Internal.BeehiveDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.SmallConnectorBlockEntity"): typeof Internal.SmallConnectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.InputType"): typeof Internal.InputType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity"): typeof Internal.LiquidBlazeBurnerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.ITinkerableContainer"): Internal.ITinkerableContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.inline.mixin.core.NativeImageAccessor"): com.samsthenerd.inline.mixin.core.NativeImageAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.tank.storage.creative.CreativeFluidTankMountedStorageType"): typeof Internal.CreativeFluidTankMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.NarrowTrackBufferBlock$Style"): typeof Internal.NarrowTrackBufferBlock$Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.TickContainerAccess"): Internal.TickContainerAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.mixin.accessor.client.AccessorRenderType"): Internal.AccessorRenderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedGameEventExtension"): Internal.InjectedGameEventExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration"): typeof Internal.SculkPatchConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.item.MountedItemStorage"): typeof Internal.MountedItemStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$20"): typeof Internal.ModBlocks$20;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Targeting"): Internal.Targeting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.robdog777.enchantmentsplus.enchants.PaybackEnchantment"): typeof Internal.PaybackEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.patternprovider.PatternProviderLogicHost"): Internal.PatternProviderLogicHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.item.SmartInventory"): typeof Internal.SmartInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe"): typeof Internal.ContainerFillingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.LivingEntityDeathEventJS"): typeof Internal.LivingEntityDeathEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern$CraftingGridAccessor"): Internal.IMolecularAssemblerSupportedPattern$CraftingGridAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IGenericCrossingTrackBE"): Internal.IGenericCrossingTrackBE;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.transport.BeltInventory$ItemsSnapshotParticipant"): typeof Internal.BeltInventory$ItemsSnapshotParticipant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Vex"): typeof Internal.Vex;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.BogeyVisual"): Internal.BogeyVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.eval.CastingEnvironment"): typeof Internal.CastingEnvironment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.blockview.BlockViewMixin"): Internal.BlockViewMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.signal.TrackEdgePoint"): typeof Internal.TrackEdgePoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.MutableArmorTier"): typeof Internal.MutableArmorTier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.computer.WandTurtleUpgrade"): typeof Internal.WandTurtleUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.pulley.PulleyBlock$RopeBlockBase"): typeof Internal.PulleyBlock$RopeBlockBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.extensions.block.SophisticatedBlockState"): Internal.SophisticatedBlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenTinFluid"): typeof Internal.MoltenTinFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper"): typeof Internal.MountedFluidStorageWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.ListPoolElement"): typeof Internal.ListPoolElement;
        /**
         * Creates a custom ConsoleJS instance for you to use to, well, log stuff
        */
        createConsole(name: string): Internal.ConsoleJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.locks.Lock"): Internal.Lock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventJS"): typeof Internal.EventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.Animation$Direction"): typeof Internal.Animation$Direction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.builders.CubeListBuilder"): typeof Internal.CubeListBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.common.tileentities.TileExInscriber"): typeof Internal.TileExInscriber;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.entity.PositionedEntityTrackingSection"): Internal.PositionedEntityTrackingSection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings"): typeof Internal.MobSpawnSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.fluix.FluixSmithingTemplateItem"): typeof Internal.FluixSmithingTemplateItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.FocusTraversalPolicy"): typeof Internal.FocusTraversalPolicy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.LinkedHashMap"): typeof Internal.LinkedHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.akashic.BlockAkashicLigature"): typeof Internal.BlockAkashicLigature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.w3c.dom.Attr"): Internal.Attr;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SnifferEggBlock"): typeof Internal.SnifferEggBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem"): typeof Internal.PumpUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.depot.EjectorBlock"): typeof Internal.EjectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity"): typeof Internal.DeployerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.SpanishMossBlock"): typeof Internal.SpanishMossBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2CharFunction"): Internal.Short2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2FloatFunction"): Internal.Double2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.blocks.HexCandleBlockEntity"): typeof Internal.HexCandleBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.item.PlateArmorItem"): typeof Internal.PlateArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.attachment.v1.AttachmentType"): Internal.AttachmentType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.config.Setting"): typeof Internal.Setting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.arsenal.item.ScytheItem"): typeof Internal.ScytheItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gantry.GantryShaftBlock"): typeof Internal.GantryShaftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.LumaloopBlock"): typeof Internal.LumaloopBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockDragonForgeInput"): typeof Internal.BlockDragonForgeInput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.IExtendedPistonTile"): Internal.IExtendedPistonTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.misc.Triplet"): typeof Internal.Triplet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.graph.TrackNodeLocation"): typeof Internal.TrackNodeLocation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PrimitiveIterator$OfDouble"): Internal.PrimitiveIterator$OfDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.MinecraftServer$ReloadableResources"): typeof Internal.MinecraftServer$ReloadableResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BeaconBlockEntityAccessor"): Internal.BeaconBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.wide.WideGaugeBogeyBlock"): typeof Internal.WideGaugeBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ProtectionEnchantment$Type"): typeof Internal.ProtectionEnchantment$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.fluix.FluixAxeItem"): typeof Internal.FluixAxeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.block.WoodenDoorBlock"): typeof Internal.WoodenDoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.stb.STBTTFontinfo"): typeof Internal.STBTTFontinfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$21"): typeof Internal.ModBlocks$21;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform"): typeof Internal.ValueBoxTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.screen.AlignMode"): typeof Internal.AlignMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.BacktankItem$Layered"): typeof Internal.BacktankItem$Layered;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallHangingSignBlock"): typeof Internal.WallHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.item.LabelItem"): typeof Internal.LabelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.palettes.ConnectedGlassBlock"): typeof Internal.ConnectedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SculkShriekerBlock"): typeof Internal.SculkShriekerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "abilliontrillionstars.hextended.items.ItemDrawingOrb"): typeof Internal.ItemDrawingOrb;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SequencedSet"): Internal.SequencedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.data.DragonArmorMaterial"): typeof Internal.DragonArmorMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.materials.extensions.BakedQuadExtensions"): Internal.BakedQuadExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.EncasedPipeBlock"): typeof Internal.EncasedPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gantry.GantryShaftBlockEntity"): typeof Internal.GantryShaftBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer$FoliageAttachment"): typeof Internal.FoliagePlacer$FoliageAttachment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.CalculationStrategy"): typeof Internal.CalculationStrategy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2BooleanMap$Entry"): Internal.Object2BooleanMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.util.FacingOrNone"): typeof Internal.FacingOrNone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.turtle.blocks.TurtleBlock"): typeof Internal.TurtleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K1"): Internal.K1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_texture_features.features.state.ETFEntityRenderState"): Internal.ETFEntityRenderState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.KnowledgeBookItem"): typeof Internal.KnowledgeBookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.lambdynlights.config.SettingEntry"): typeof Internal.SettingEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ObjectFunction"): Internal.Char2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.Blocks"): typeof Blocks;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.CastingBasinBlock"): typeof Internal.CastingBasinBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleToIntFunction"): Internal.DoubleToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe"): typeof Internal.AbstractWorktableRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRotateHeadPacket"): typeof Internal.ClientboundRotateHeadPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.ItemThroughputDisplaySource"): typeof Internal.ItemThroughputDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlockEntity"): typeof Internal.RedstoneRelayBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.RewriteResult"): typeof Internal.RewriteResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType"): typeof Internal.Dynamic3CommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateTagsProvider$IntrinsicImpl"): typeof Internal.RegistrateTagsProvider$IntrinsicImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.FrostWalkerEnchantment"): typeof Internal.FrostWalkerEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.world.features.MarsBlockBlobFeature"): typeof Internal.MarsBlockBlobFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.circles.ICircleComponent"): Internal.ICircleComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.WithPersistentData"): Internal.WithPersistentData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.loot.v2.FabricLootPoolBuilder"): Internal.FabricLootPoolBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$ListN"): typeof Internal.ImmutableCollections$ListN;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.ITabbedBlock"): Internal.ITabbedBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.mixin.shader.ShaderProgramAccessor"): Internal.ShaderProgramAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage"): typeof Internal.CombinedStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CoralFanBlock"): typeof Internal.CoralFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RepeaterBlock"): typeof Internal.RepeaterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.link.RedstoneLinkBlock"): typeof Internal.RedstoneLinkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeItem"): typeof Internal.DyeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.registry.fluid.BotariumSourceFluid"): typeof Internal.BotariumSourceFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.RadioBlock"): typeof Internal.RadioBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.data.ItemModelType"): typeof Internal.ItemModelType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.definition.ToolDefinition"): typeof Internal.ToolDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.burner.BlazeBurnerBlock"): typeof Internal.BlazeBurnerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ArrowInfiniteEnchantment"): typeof Internal.ArrowInfiniteEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.core.terminal.TextBuffer"): typeof Internal.TextBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P3"): typeof Internal.Products$P3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmokingUpgradeItem"): typeof Internal.SmokingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.TamableAnimal"): typeof Internal.TamableAnimal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo"): typeof Internal.FloatArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.generators.block.MultiPartBlockStateBuilder"): typeof Internal.MultiPartBlockStateBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.EntityRenderDispatcher"): typeof Internal.EntityRenderDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.BoundingBox"): typeof Internal.BoundingBox;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.templates.RecursivePoint$RecursivePointType"): typeof Internal.RecursivePoint$RecursivePointType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.casting.arithmetic.BitwiseSetArithmetic"): typeof Internal.BitwiseSetArithmetic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.iota.IotaType"): typeof Internal.IotaType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenElectrumFluid$Flowing"): typeof Internal.MoltenElectrumFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.DesertWellFeature"): typeof Internal.DesertWellFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.render.SpriteShiftEntry"): typeof Internal.SpriteShiftEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MangrovePropaguleBlock"): typeof Internal.MangrovePropaguleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.WritableRenderedImage"): Internal.WritableRenderedImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.BlackSandSplatterFeature"): typeof Internal.BlackSandSplatterFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.decoration.BlockHexStairs"): typeof Internal.BlockHexStairs;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.builders.NoConfigBuilder"): typeof Internal.NoConfigBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.WindowListener"): Internal.WindowListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents$Teleport"): Internal.EntityEvents$Teleport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Tilt"): typeof Internal.Tilt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.io.Serializable"): Internal.Serializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.QuickChargeEnchantment"): typeof Internal.QuickChargeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenCopperFluid"): typeof Internal.MoltenCopperFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Function16"): Internal.Function16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem"): typeof Internal.MagnetUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Fox$Type"): typeof Internal.Fox$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.LogType"): typeof Internal.LogType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Pig"): typeof Internal.Pig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.GraphicsDevice$WindowTranslucency"): typeof Internal.GraphicsDevice$WindowTranslucency;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TravellingPoint"): typeof Internal.TravellingPoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tableCloth.TableClothBlock"): typeof Internal.TableClothBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity"): typeof Internal.CalibratedSculkSensorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.ItemFrameAccessor"): Internal.ItemFrameAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock"): typeof Internal.ConductorWhistleFlagBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity"): typeof Internal.NixieTubeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock"): typeof Internal.ElevatorContactBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket"): typeof Internal.ServerboundContainerButtonClickPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.VanillaPackResources"): typeof Internal.VanillaPackResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.VirtualFluid"): typeof Internal.VirtualFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Type"): typeof Internal.GameRules$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.mixin.fabric.BiomeAccessor"): Internal.BiomeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.fuel.tank.FuelTankMountedStorageType"): typeof Internal.FuelTankMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ShieldItem"): typeof Internal.ShieldItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.block.ClearGlassPaneBlock"): typeof Internal.ClearGlassPaneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "malte0811.ferritecore.mixin.blockstatecache.VoxelShapeAccess"): Internal.VoxelShapeAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity"): typeof Internal.PulleyBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.IConfigInvHost"): Internal.IConfigInvHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BlockBlobFeature"): typeof Internal.BlockBlobFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ProfileResults"): Internal.ProfileResults;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagArgument"): typeof Internal.ResourceOrTagArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.CompressorHolder"): typeof Internal.CompressorHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.ICraftingSimulationRequester"): Internal.ICraftingSimulationRequester;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket$Action"): typeof Internal.ClientboundCustomChatCompletionsPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.main.GameConfig"): typeof Internal.GameConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.crafting.CookingPotRecipe$Serializer"): typeof Internal.CookingPotRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.util.IWallBlock"): Internal.IWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HangingStrandBottomBlock"): typeof Internal.HangingStrandBottomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.extensions.item.SophisticatedItemStack"): Internal.SophisticatedItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.rolling.RollingRecipe"): typeof Internal.RollingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectList"): Internal.ObjectList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.registries.DeferredSupplier"): Internal.DeferredSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.recipes.handlers.ChargerRecipeSerializer"): typeof Internal.ChargerRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuCategory"): Internal.SpectatorMenuCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2DoubleFunction"): Internal.Double2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.moreiotas.common.casting.arithmetic.StringArithmetic"): typeof Internal.StringArithmetic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.base.BaseComponent"): typeof Internal.BaseComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.RegistryLayer"): typeof Internal.RegistryLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.robdog777.enchantmentsplus.enchants.DualLeapEnchantment"): typeof Internal.DualLeapEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Symbol"): Internal.Symbol;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ConstantInt"): typeof Internal.ConstantInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.BasicBlockJS$Builder"): typeof Internal.BasicBlockJS$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureFlagSet"): typeof Internal.FeatureFlagSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.FlyingMob"): typeof Internal.FlyingMob;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimatableManager$ControllerRegistrar"): typeof Internal.AnimatableManager$ControllerRegistrar;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorBlockEntityType"): Internal.AccessorBlockEntityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.MenuProvider"): Internal.MenuProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.properties.PipeProperty"): typeof Internal.PipeProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.jamalam360.rightclickharvest.mixin.CropBlockAccessor"): Internal.CropBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallSignBlock"): typeof Internal.WallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer"): typeof Internal.DarkOakTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.MyceliumSplatterFeature"): typeof Internal.MyceliumSplatterFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.PlacementContext"): typeof Internal.PlacementContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SeagrassBlock"): typeof Internal.SeagrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.command.arguments.RepeatArgumentType$Info"): typeof Internal.RepeatArgumentType$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.BigPumpkinFeature"): typeof Internal.BigPumpkinFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.tool.extensions.BlockStateExtensions"): Internal.BlockStateExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.client.RealmsClient$CompatibleVersionResponse"): typeof Internal.RealmsClient$CompatibleVersionResponse;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.LevelStem"): typeof Internal.LevelStem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.SoundEventBuilder"): typeof Internal.SoundEventBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.ItemDragonSeeker"): typeof Internal.ItemDragonSeeker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeSupplier"): typeof Internal.AttributeSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.loot.extensions.LootPoolBuilderExtension"): Internal.LootPoolBuilderExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket"): typeof Internal.ClientboundMerchantOffersPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator"): Internal.Spliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.CarriageSounds"): typeof Internal.CarriageSounds;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_tracks.NoCollisionCustomTrackBlock"): typeof Internal.NoCollisionCustomTrackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary"): typeof Internal.OperatorBinary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.gadgets.item.PiggyBackPackItem$CarryPotionEffect"): typeof Internal.PiggyBackPackItem$CarryPotionEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BonusChestFeature"): typeof Internal.BonusChestFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonHoverPhase"): typeof Internal.DragonHoverPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.PushReaction"): typeof Internal.PushReaction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.goal.Goal"): typeof Internal.Goal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionContainer"): Internal.ConditionContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.render.RenderContext$QuadTransform"): Internal.RenderContext$QuadTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.impl.ItemPropertiesExtensionImpl"): Internal.ItemPropertiesExtensionImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.wrapper.AABBWrapper"): AABB;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2DoubleFunction"): Internal.Int2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts$CraftingEntry"): typeof Internal.PackageOrderWithCrafts$CraftingEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.network.ObservePacket"): typeof Internal.ObservePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BannerPattern"): typeof Internal.BannerPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelStorageSource"): typeof Internal.LevelStorageSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.LightShader"): Internal.LightShader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.SmallBrownMushroomFeature"): typeof Internal.SmallBrownMushroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions$Deserializer"): Internal.ParticleOptions$Deserializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.gadgets.item.slimesling.EarthSlimeSlingItem"): typeof Internal.EarthSlimeSlingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.GiantGlowshroomFeature"): typeof Internal.GiantGlowshroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.menuobjects.ItemMenuHost"): typeof Internal.ItemMenuHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.CarvingMask$Mask"): Internal.CarvingMask$Mask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe"): typeof Internal.AlloyRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity$FuelType"): typeof Internal.BlazeBurnerBlockEntity$FuelType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenEvents$BeforeRender"): Internal.ScreenEvents$BeforeRender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriSoilCondition$Type"): typeof Internal.AgriSoilCondition$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.ItemLoreFragment"): typeof Internal.ItemLoreFragment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.tank.FluidTankBlockEntity"): typeof Internal.FluidTankBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BeeDebugRenderer"): typeof Internal.BeeDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockDreadSpawner"): typeof Internal.BlockDreadSpawner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.powersink.AEBasePoweredItem"): typeof Internal.AEBasePoweredItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeWrapper"): typeof Internal.MagnetUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.AbstractLong2ObjectFunction"): typeof Internal.AbstractLong2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.FishingLootEventJS"): typeof Internal.FishingLootEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "kotlin.Function"): kotlin.Function;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.fabric.ModelManagerAccessor"): Internal.ModelManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.item.ItemExtensions"): Internal.ItemExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Scoreboard"): typeof Internal.Scoreboard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.vault.ItemVaultMountedStorage"): typeof Internal.ItemVaultMountedStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ClientLevelKJS"): Internal.ClientLevelKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.SlotAccess"): Internal.SlotAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$19"): typeof Internal.ModBlocks$19;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.WallLamp"): typeof Internal.WallLamp;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities"): typeof Internal.NearestVisibleLivingEntities;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.events.GridEvent"): typeof Internal.GridEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlockEntityTicker"): Internal.BlockEntityTicker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour"): typeof Internal.FactoryPanelSupportBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer"): typeof Internal.CherryTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.registry.fluid.FluidBucketItem"): typeof Internal.FluidBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.item.ItemHelper$ExtractionCountMode"): typeof Internal.ItemHelper$ExtractionCountMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.state.CanvasSign"): Internal.CanvasSign;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.gen.properties.AddOreProperties"): typeof Internal.AddOreProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.data.GenericLoaderRegistry$IGenericLoader"): Internal.GenericLoaderRegistry$IGenericLoader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BlockStateComponent"): typeof Internal.BlockStateComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.WrappedJS"): Internal.WrappedJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DetectorRailBlock"): typeof Internal.DetectorRailBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntLineConsumer"): Internal.DiscreteVoxelShape$IntLineConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.FrogVariant"): typeof Internal.FrogVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.computer.WandPocketUpgrade$UpgradeSerialiser"): typeof Internal.WandPocketUpgrade$UpgradeSerialiser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.decorative.solid.QuartzLampBlock"): typeof Internal.QuartzLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ReflectionAccessFilter"): Internal.ReflectionAccessFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.AdvancementJS"): typeof Internal.AdvancementJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock"): typeof Internal.DiskDriveBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.misc.ChargerBlock"): typeof Internal.ChargerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.RecipeTypeFunction"): typeof Internal.RecipeTypeFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongPredicate"): it.unimi.dsi.fastutil.longs.LongPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.LevelReaderExtensions"): Internal.LevelReaderExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.recipe.ModifierRemovalRecipe$Serializer"): typeof Internal.ModifierRemovalRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$EmptyTextureStateShard"): typeof Internal.RenderStateShard$EmptyTextureStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.belt.ChorusTotemItem"): typeof Internal.ChorusTotemItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.context.EquipmentContext"): typeof Internal.EquipmentContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gauge.GaugeShaper"): typeof Internal.GaugeShaper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockModel$GuiLight"): typeof Internal.BlockModel$GuiLight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.widget.Bounds"): typeof Internal.Bounds;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.ClientEventJS"): typeof Internal.ClientEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket"): typeof Internal.ClientboundSetBorderWarningDistancePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.LerpingBossEvent"): typeof Internal.LerpingBossEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.spatial.ISpatialService"): Internal.ISpatialService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.util.pond.OwoScreenExtension"): Internal.OwoScreenExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ForwardingCollection"): typeof Internal.ForwardingCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.config.CpuSelectionMode"): typeof Internal.CpuSelectionMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPongPacket"): typeof Internal.ServerboundPongPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.hooks.AEToolItem"): Internal.AEToolItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.pipes.PipeDuctBlock"): typeof Internal.PipeDuctBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.KeyMappingAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.KeyMappingAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient"): typeof Internal.BrainsweepeeIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.ResourceLocationExtensions"): Internal.ResourceLocationExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.crop.AgriGrowthStage"): typeof Internal.AgriGrowthStage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.ai.MemoryModificationCounter"): Internal.MemoryModificationCounter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeMap"): typeof Internal.AttributeMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.recipe.ProcessingRecipe"): typeof Internal.ProcessingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.audio.SoundBuffer"): typeof Internal.SoundBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.Boat"): typeof Internal.Boat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.Inventory"): typeof Internal.Inventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlock"): typeof Internal.RedstoneRequesterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookCopyAttribute$Type"): typeof Internal.BookCopyAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer$DebugGoal"): typeof Internal.GoalSelectorDebugRenderer$DebugGoal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.batchedentityrendering.impl.TransparencyType"): typeof Internal.TransparencyType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ChorusFruitItem"): typeof Internal.ChorusFruitItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeBuilder"): Internal.RecipeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4dc"): Internal.Matrix4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.belt.HeliumFlamingoItem"): typeof Internal.HeliumFlamingoItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.qnb.QuantumLinkChamberBlock"): typeof Internal.QuantumLinkChamberBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.EasingType$CatmullRomEasing"): typeof Internal.EasingType$CatmullRomEasing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.block.ExplosionResistanceBlock"): Internal.ExplosionResistanceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.PlayerModelPart"): typeof Internal.PlayerModelPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.rolling.SequencedAssemblyRollingRecipeSerializer"): typeof Internal.SequencedAssemblyRollingRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.misc.InterfaceBlock"): typeof Internal.InterfaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FarmBlock"): typeof Internal.FarmBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeWrapper"): typeof Internal.FeedingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.StateDefinition"): typeof Internal.StateDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$ItemDisplay"): typeof Internal.Display$ItemDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenEvents$BeforeTick"): Internal.ScreenEvents$BeforeTick;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings$SpawnerData"): typeof Internal.MobSpawnSettings$SpawnerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity"): typeof Internal.StressGaugeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.AbstractPortableCell"): typeof Internal.AbstractPortableCell;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe"): typeof Internal.ShapedRetexturedRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.pocket.core.PocketServerComputer"): typeof Internal.PocketServerComputer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.arsenal.enchantment.ReelingEnchantment"): typeof Internal.ReelingEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.GuiEventListener"): Internal.GuiEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierMaterialRepairSerializer"): typeof Internal.ModifierMaterialRepairSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator"): Internal.ShortBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes$DeployerType"): typeof Internal.AllArmInteractionPointTypes$DeployerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator"): typeof Internal.VariantBlockStateGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.parameters.LootContextParamSet"): typeof Internal.LootContextParamSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.SystemReport"): typeof Internal.SystemReport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature"): typeof Internal.WaterloggedVegetationPatchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator"): it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute"): typeof Internal.CommonVertexAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.AbstractMultimap"): typeof Internal.AbstractMultimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.unit.VariableSet"): typeof Internal.VariableSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.alphamode.star.mixin.EntityAccessor"): me.alphamode.star.mixin.EntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsServer$State"): typeof Internal.RealmsServer$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorPortableStorageInterfaceBlockEntity"): Internal.AccessorPortableStorageInterfaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimited"): Internal.ILimited;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.DataSenderKJS"): Internal.DataSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack"): typeof Internal.TransportedItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory"): Internal.ISettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.generators.IGeneratedBlockState"): Internal.IGeneratedBlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingTableBehaviorEnchantment"): Internal.CustomEnchantingTableBehaviorEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.client.render.effects.EnergyParticleData"): typeof Internal.EnergyParticleData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.FrontAndTop"): typeof Internal.FrontAndTop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.ItemInHandRenderer"): typeof Internal.ItemInHandRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder$Living"): typeof Internal.FabricEntityTypeBuilder$Living;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TintedGlassBlock"): typeof Internal.TintedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Key"): typeof Internal.GameRules$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.ChatFormatting"): typeof Internal.ChatFormatting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.EntityLookup"): typeof Internal.EntityLookup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.UseOnContextAccessor"): com.simibubi.create.foundation.mixin.accessor.UseOnContextAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.AbstractContainerScreenAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.AbstractContainerScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.ChunkGenerator"): typeof Internal.ChunkGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker"): Internal.IMagnetPreventionChecker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockBehaviour$BlockStateBase"): typeof Internal.BlockBehaviour$BlockStateBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay"): typeof Internal.Display$TextDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.ListTag"): typeof Internal.ListTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeepingVinesPlantBlock"): typeof Internal.WeepingVinesPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.TextureAtlasExtension"): Internal.TextureAtlasExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.BoilerDisplaySource"): typeof Internal.BoilerDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.mixin.itemgroup.ItemGroupAccessor"): io.wispforest.owo.mixin.itemgroup.ItemGroupAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.blocks.HexCandleBlock"): typeof Internal.HexCandleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.quartz.QuartzSwordItem"): typeof Internal.QuartzSwordItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.AnyOfCondition$Builder"): typeof Internal.AnyOfCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider"): Internal.BlockEntityRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.requirement.ItemRequirement$StackRequirement"): typeof Internal.ItemRequirement$StackRequirement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.CopperPipeBlock"): typeof Internal.CopperPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator$Part"): typeof Internal.MultipartBlockStateGenerator$Part;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundInteractPacket$Handler"): Internal.ServerboundInteractPacket$Handler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DiodeBlock"): typeof Internal.DiodeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure"): typeof Internal.NetherFossilStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.stack.EmiIngredient"): Internal.EmiIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialStepInstance"): Internal.TutorialStepInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.maxhenkel.voicechat.mixin.ConnectionAccessor"): Internal.ConnectionAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.WirelessTerminalItem$LinkableHandler"): typeof Internal.WirelessTerminalItem$LinkableHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.font.FontRenderContext"): typeof Internal.FontRenderContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentHashMap"): typeof Internal.ConcurrentHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.crop.AgriCrop"): Internal.AgriCrop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortPredicate"): Internal.ShortPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToIntFunction"): Internal.LongToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.block.discharger.EnergyDischargerBlock"): typeof Internal.EnergyDischargerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket"): typeof Internal.ServerboundPlayerActionPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$LineSplitter"): Internal.Display$TextDisplay$LineSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.items.TooltipBlockItem"): typeof Internal.TooltipBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3dc"): Internal.Matrix4x3dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.infrastructure.worldgen.LayerPattern$Layer$Builder"): typeof Internal.LayerPattern$Layer$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.registry.fluid.FluidData"): Internal.FluidData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType"): typeof Internal.RandomSpreadType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock"): typeof Internal.ModularAccumulatorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BaseCoralFanBlock"): typeof Internal.BaseCoralFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.UnmodifiableIterator"): typeof Internal.UnmodifiableIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IFuelInventory"): Internal.IFuelInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LivingEntityAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LivingEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.depot.storage.DepotMountedStorage"): typeof Internal.DepotMountedStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.ChunkAccess$TicksToSave"): typeof Internal.ChunkAccess$TicksToSave;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.Structure$StructureSettings"): typeof Internal.Structure$StructureSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.recipes.mattercannon.MatterCannonAmmo"): typeof Internal.MatterCannonAmmo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.widget.Widget"): typeof Internal.Widget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryEventSender"): Internal.TelemetryEventSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CalibratedSculkSensorBlock"): typeof Internal.CalibratedSculkSensorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignedMessageLink"): typeof Internal.SignedMessageLink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FilterMask"): typeof Internal.FilterMask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder"): typeof Internal.ModifierStatsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuListener"): Internal.SpectatorMenuListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RootedDirtBlock"): typeof Internal.RootedDirtBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemPickedUpEventJS"): typeof Internal.ItemPickedUpEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions"): typeof Internal.PlacementOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2CharFunction"): Internal.Byte2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.slf4j.Marker"): org.slf4j.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseListener"): Internal.MouseListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky"): Internal.IPeripheralTileDucky;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.DimensionDataStorage"): typeof Internal.DimensionDataStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StainedGlassPaneBlock"): typeof Internal.StainedGlassPaneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$7"): typeof Internal.ModBlocks$7;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBossEventPacket"): typeof Internal.ClientboundBossEventPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.compat.recipeViewerCommon.SequencedAssemblySubCategoryType"): typeof Internal.SequencedAssemblySubCategoryType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler"): typeof Internal.MetricSampler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.table.SchematicTableBlock"): typeof Internal.SchematicTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidWrapper"): typeof Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType"): typeof Internal.RootPlacerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions"): Internal.NetworkHandlerExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$CycleableValueSet"): Internal.OptionInstance$CycleableValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCooldownPacket"): typeof Internal.ClientboundCooldownPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.PrivilegedAction"): Internal.PrivilegedAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownPotion"): typeof Internal.ThrownPotion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.gen.RemoveWorldgenEventJS"): typeof Internal.RemoveWorldgenEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.periut.chisel.item.ChiselItem"): typeof Internal.ChiselItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IBlockHolder"): Internal.IBlockHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.w3c.dom.Element"): Internal.Element;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.w3c.dom.CharacterData"): Internal.CharacterData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.ContainerEventHandler"): Internal.ContainerEventHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoublePredicate"): it.unimi.dsi.fastutil.doubles.DoublePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.table.SchematicTableBlockEntity"): typeof Internal.SchematicTableBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenSteelFluid$Flowing"): typeof Internal.MoltenSteelFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock"): typeof Internal.MechanicalPistonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.ConfigWriter"): Internal.ConfigWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.hands.PocketPistonItem"): typeof Internal.PocketPistonItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.lookup.block.BlockApiCacheImpl"): typeof Internal.BlockApiCacheImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlockEntity"): typeof Internal.SmallLightConnectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents$AllowMouseRelease"): Internal.ScreenMouseEvents$AllowMouseRelease;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties"): typeof Internal.AddLakeProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Shearable"): Internal.Shearable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler$MetricSamplerBuilder"): typeof Internal.MetricSampler$MetricSamplerBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4dc"): Internal.Vector4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.widget.AbstractSimiWidget"): typeof Internal.AbstractSimiWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld"): typeof Internal.VirtualRenderWorld;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HangingCobwebBlock"): typeof Internal.HangingCobwebBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration"): typeof Internal.CustomMapDecoration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.common.tileentities.TileWirelessConnector"): typeof Internal.TileWirelessConnector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement"): Internal.SpecialBlockItemRequirement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity"): typeof Internal.MillstoneBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.porting_lib.base.util.LazyOptional"): typeof Internal.LazyOptional;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.recipes.handlers.InscriberProcessType"): typeof Internal.InscriberProcessType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.moreiotas.api.casting.iota.ItemTypeIota"): typeof Internal.ItemTypeIota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.DateFormatSymbols"): typeof Internal.DateFormatSymbols;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemModAxe"): typeof Internal.ItemModAxe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.EntitySection"): typeof Internal.EntitySection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.control.LookControl"): typeof Internal.LookControl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpikeFeature$EndSpike"): typeof Internal.SpikeFeature$EndSpike;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Turtle"): typeof Internal.Turtle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Collections$UnmodifiableRandomAccessList"): typeof Internal.Collections$UnmodifiableRandomAccessList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$RTree$Node"): typeof Internal.Climate$RTree$Node;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.PatternProviderBlock"): typeof Internal.PatternProviderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.SmallFumaroleFeature"): typeof Internal.SmallFumaroleFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SlabBlock"): typeof Internal.SlabBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSelector"): typeof Internal.VibrationSelector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.Easing"): Internal.Easing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.ItemWrapper"): Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.diodes.PoweredLatchBlock"): typeof Internal.PoweredLatchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.geom.Rectangle2D"): typeof Internal.Rectangle2D;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K2"): Internal.K2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.ProfileKeyPair"): typeof Internal.ProfileKeyPair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.world.interests.PointOfInterestStorageExtended"): Internal.PointOfInterestStorageExtended;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SweetBerryBushBlock"): typeof Internal.SweetBerryBushBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.parameters.LootContextParam"): typeof Internal.LootContextParam;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.LavaFluid$Flowing"): typeof Internal.LavaFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.spruceui.Position"): typeof dev.lambdaurora.spruceui.Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.polymorph.mixin.core.AccessorAbstractFurnaceBlockEntity"): Internal.AccessorAbstractFurnaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement"): typeof Internal.EnvironmentScanPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.mixin.client.accessor.BufferBuilderAccessor"): Internal.BufferBuilderAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.CameraType"): typeof Internal.CameraType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.unascribed.lib39.phantom.api.PhaseableWorld"): Internal.PhaseableWorld;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.DeltaFeature"): typeof Internal.DeltaFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.item.CopperCanItem"): typeof Internal.CopperCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterator"): Internal.LongIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor"): net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.FireworkStarRecipe"): typeof Internal.FireworkStarRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpringFeature"): typeof Internal.SpringFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher"): typeof Internal.BlockEntityRenderDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BannerBlock"): typeof Internal.BannerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$GenericInterpolator"): Internal.Display$GenericInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.machines.EtrionicBlastFurnaceBlock"): typeof Internal.EtrionicBlastFurnaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor"): com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.AnomalyBlock"): typeof Internal.AnomalyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagManager$LoadResult"): typeof Internal.TagManager$LoadResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HugeCloverPetalBlock"): typeof Internal.HugeCloverPetalBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.AABB"): typeof Internal.AABB;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager"): typeof Internal.StructureTemplateManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.mixin.fabric.LiquidBlockAccessor"): Internal.LiquidBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.decorative.solid.BuddingCertusQuartzBlock"): typeof Internal.BuddingCertusQuartzBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.GameMasterBlockItem"): typeof Internal.GameMasterBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.paint.PaintSplotchesBlock"): typeof Internal.PaintSplotchesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.fluid.XPFluid$Flowing"): typeof Internal.XPFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource"): typeof Internal.SingleLineDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.CabbageBlock"): typeof Internal.CabbageBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldgenRandom"): typeof Internal.WorldgenRandom;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.SmallGlowshroomFeature"): typeof Internal.SmallGlowshroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.inject.GreedyInputComponent"): Internal.GreedyInputComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec$ResultFunction"): Internal.Codec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.stacks.AEKeyType"): typeof Internal.AEKeyType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure"): typeof Internal.SwampHutStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank"): typeof io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.item.AccessorItemCooldowns"): Internal.AccessorItemCooldowns;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionalFunction"): typeof Internal.ConditionalFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.effect.ShockingEffect"): typeof Internal.ShockingEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockIceSpikes"): typeof Internal.BlockIceSpikes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.Keyframe"): typeof Internal.Keyframe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.CommandSourceStack"): typeof Internal.CommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.AllRecipeTypes$1"): typeof Internal.AllRecipeTypes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.SpawnPlacements$Type"): typeof Internal.SpawnPlacements$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.core.metrics.Metric$Event"): typeof Internal.Metric$Event;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.item.TankItem"): typeof Internal.TankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator$Variant"): typeof Internal.VariantBlockStateGenerator$Variant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.commons.lang3.tuple.Pair"): typeof org.apache.commons.lang3.tuple.Pair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CampfireBlock"): typeof Internal.CampfireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour"): typeof Internal.VersionedInventoryTrackerBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.ChunkMap"): typeof Internal.ChunkMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemSmeltedEventJS"): typeof Internal.ItemSmeltedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockSeaSerpentScales"): typeof Internal.BlockSeaSerpentScales;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.Rect2i"): typeof Internal.Rect2i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Program$Type"): typeof Internal.Program$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.plough.PloughBlock"): typeof Internal.PloughBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.template.BookTemplate"): typeof Internal.BookTemplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriSeed$Builder"): typeof Internal.AgriSeed$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.MemoryCardItem"): typeof Internal.MemoryCardItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableList$Builder"): typeof Internal.ImmutableList$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SequencedMap"): Internal.SequencedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlock"): typeof Internal.WaterWheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.smartObserver.SmartObserverBlock"): typeof Internal.SmartObserverBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.TabStop"): typeof Internal.TabStop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.network.SerializableDataTicket"): typeof Internal.SerializableDataTicket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.util.prioritylist.IPartitionList$Builder"): typeof Internal.IPartitionList$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.IntegerProperty"): typeof Internal.IntegerProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.ItemAccessor"): net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.ItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.pocket.items.PocketComputerItem"): typeof Internal.PocketComputerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.ItemDeathwormEgg"): typeof Internal.ItemDeathwormEgg;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2IntFunction"): Internal.Byte2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.helper.AbstractRecipeSerializer"): typeof Internal.AbstractRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.Pack"): typeof Internal.Pack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.energy.base.EnergySnapshot"): Internal.EnergySnapshot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenSilverFluid$Flowing"): typeof Internal.MoltenSilverFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Paint"): Internal.Paint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2BooleanFunction"): Internal.Char2BooleanFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.filter.FilterUpgradeWrapper"): typeof Internal.FilterUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.definition.IToolStatProvider"): Internal.IToolStatProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.random.RandomGenerator"): Internal.RandomGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.trinkets.mixin.accessor.ScreenHandlerAccessor"): Internal.ScreenHandlerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.LingeringPotionItem"): typeof Internal.LingeringPotionItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.casting.iota.RitualIota$RitualIotaType"): typeof Internal.RitualIota$RitualIotaType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeWrapper"): typeof Internal.RestockUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderBuffers"): typeof Internal.RenderBuffers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$ColorType"): typeof Internal.PageAttributes$ColorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.HangingFleshTendonFeature"): typeof Internal.HangingFleshTendonFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.SoundBufferLibrary"): typeof Internal.SoundBufferLibrary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock"): typeof Internal.PackagerLinkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity"): typeof Internal.BaseComfortsBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner"): typeof Internal.InventoryPartitioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationController$SoundKeyframeHandler"): Internal.AnimationController$SoundKeyframeHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Stack"): typeof Internal.Stack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smithing.SmithingUpgradeWrapper"): typeof Internal.SmithingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$Ap2"): typeof Internal.DensityFunctions$Ap2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.chunkstorage.impl.DataStorage"): typeof Internal.DataStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack"): Internal.ClientCommandRegistrationEvent$ClientCommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.generators.item.ItemModelBuilder$OverrideBuilder"): typeof Internal.ItemModelBuilder$OverrideBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BellBlock"): typeof Internal.BellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.transform.Transform"): Internal.Transform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.pocket.core.PocketHolder"): Internal.PocketHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid"): typeof Internal.ModelCuboid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.AttackDamageMobEffect"): typeof Internal.AttackDamageMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.mixin.world.block_entity_ticking.sleeping.WrappedBlockEntityTickInvokerAccessor"): Internal.WrappedBlockEntityTickInvokerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.CARecipeSerializer"): typeof Internal.CARecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureBlockInfo"): typeof Internal.StructureTemplate$StructureBlockInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.PlacementModifier"): typeof Internal.PlacementModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.modifiers.effect.NoMilkEffect"): typeof Internal.NoMilkEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SimpleBlockFeature"): typeof Internal.SimpleBlockFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry$ListenerVisitor"): Internal.GameEventListenerRegistry$ListenerVisitor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ForwardingSet"): typeof Internal.ForwardingSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.waterwheel.LargeWaterWheelBlockItem"): typeof Internal.LargeWaterWheelBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent"): typeof Internal.ParticleKeyframeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.PressurePlateBlockBuilder"): typeof Internal.PressurePlateBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.DrinkableItem"): typeof Internal.DrinkableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.world.structure.MausoleumStructure"): typeof Internal.MausoleumStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.item.RakeItem$RakeLogic"): Internal.RakeItem$RakeLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleSupplier"): Internal.DoubleSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator"): Internal.ICustomSizeNavigator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.command.EnumArgument$Info"): typeof Internal.EnumArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.millstone.MillstoneBlock"): typeof Internal.MillstoneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ThornsEnchantment"): typeof Internal.ThornsEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Struct$StructValidation"): Internal.Struct$StructValidation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.component.SearedGlassBlock"): typeof Internal.SearedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.AmbientAdditionsSettings"): typeof Internal.AmbientAdditionsSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderType$CompositeState$CompositeStateBuilder"): typeof Internal.RenderType$CompositeState$CompositeStateBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.decorative.solid.CertusQuartzClusterBlock"): typeof Internal.CertusQuartzClusterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration"): typeof Internal.LargeDripstoneConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks$Ground"): typeof Internal.IafDragonAttacks$Ground;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.lookup.BlockEntityTypeAccessor"): Internal.BlockEntityTypeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.link.controller.LinkedControllerItem"): typeof Internal.LinkedControllerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.LampPostItem"): typeof Internal.LampPostItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.item.SeedBagItem$BagEntry"): typeof Internal.SeedBagItem$BagEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientLevel"): typeof Internal.ClientLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.TinkerStationBlock"): typeof Internal.TinkerStationBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.interfaces.PlayerEntityMinterface"): Internal.PlayerEntityMinterface;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.AbstractList"): typeof Internal.AbstractList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.periut.factoryblocks.block.fan.RedstoneFanBlock"): typeof Internal.RedstoneFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.BrimstoneClusterBlock"): typeof Internal.BrimstoneClusterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "malte0811.ferritecore.fastmap.FastMapKey"): typeof Internal.FastMapKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.item.ChargedSnowballItem"): typeof Internal.ChargedSnowballItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.NetherForestVegetationFeature"): typeof Internal.NetherForestVegetationFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LayeredCauldronBlock"): typeof Internal.LayeredCauldronBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.base.Suppliers$NonSerializableMemoizingSupplier"): typeof Internal.Suppliers$NonSerializableMemoizingSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.SmartFluidPipeBlock"): typeof Internal.SmartFluidPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.digital_adapter.DigitalAdapterDisplaySource"): typeof Internal.DigitalAdapterDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.recipe.EmiRecipe"): Internal.EmiRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.CreateOreExcavation$1"): typeof Internal.CreateOreExcavation$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.distant_signals.IOverridableSignal"): Internal.IOverridableSignal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.HighGrassFeature"): typeof Internal.HighGrassFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration"): typeof Internal.ColumnFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.NumberComponent$IntRange"): typeof Internal.NumberComponent$IntRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StainedGlassBlock"): typeof Internal.StainedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.GeodeCrackSettings"): typeof Internal.GeodeCrackSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration"): typeof Internal.OreConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.renderable.RenderableImage"): Internal.RenderableImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Graphics"): typeof Internal.Graphics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.CardinalLightingMode"): typeof Internal.CardinalLightingMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.LongConfig"): typeof Internal.LongConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.StructureTransform"): typeof Internal.StructureTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket"): typeof Internal.ClientboundUpdateAdvancementsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.conductor.fabric.ConductorCapItemImpl"): typeof Internal.ConductorCapItemImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.lectern.CustomLecternBlockEntity"): typeof Internal.CustomLecternBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.deployer.DeployerBlock"): typeof Internal.DeployerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.powersink.AEBasePoweredBlockEntity"): typeof Internal.AEBasePoweredBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2LongFunction"): Internal.Boolean2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.FireworkRocketItem$Shape"): typeof Internal.FireworkRocketItem$Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.StairBlockBuilder"): typeof Internal.StairBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.PathfindingRenderer"): typeof Internal.PathfindingRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.PositionSourceType"): Internal.PositionSourceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout"): Internal.WidgetLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.stacks.AEItemKeys"): typeof Internal.AEItemKeys;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.MenuAccess"): Internal.MenuAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.IdMap"): Internal.IdMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$TextureStateShard"): typeof Internal.RenderStateShard$TextureStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureElement"): Internal.FeatureElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonPrimitive"): typeof Internal.JsonPrimitive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ServerData$ServerPackStatus"): typeof Internal.ServerData$ServerPackStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.util.ItemBase"): typeof Internal.ItemBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPart"): Internal.IPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.tree.TaigaTreeFeature"): typeof Internal.TaigaTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.PrivacyMode"): typeof Internal.PrivacyMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.display.GlobalTrainDisplayData$TrainDeparturePrediction"): typeof Internal.GlobalTrainDisplayData$TrainDeparturePrediction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.pigment.ItemDyePigment"): typeof Internal.ItemDyePigment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.LampBlock"): typeof Internal.LampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenSilverFluid"): typeof Internal.MoltenSilverFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.PhantomNodeBlock"): typeof Internal.PhantomNodeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner"): Internal.ClientTooltipPositioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPartItem"): Internal.IPartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.modernfix.duck.IProfilingServerFunctionManager"): Internal.IProfilingServerFunctionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.server.IntegratedServer"): typeof Internal.IntegratedServer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.client.sound.SoundInstanceMixin"): Internal.SoundInstanceMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jdk.internal.foreign.AbstractMemorySegmentImpl"): typeof Internal.AbstractMemorySegmentImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockDreadTorch"): typeof Internal.BlockDreadTorch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeSaplingBlock"): typeof Internal.SlimeSaplingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.thread.ReentrantBlockableEventLoop"): typeof Internal.ReentrantBlockableEventLoop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "wallywhip.resourcechickens.init.initItems$1"): typeof Internal.initItems$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TrainStatus"): typeof Internal.TrainStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.context.ToolRebuildContext"): typeof Internal.ToolRebuildContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.families.Algebra"): Internal.Algebra;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.inline.mixin.feature.playerskins.MixinClientAccessor"): Internal.MixinClientAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPingPacket"): typeof Internal.ClientboundPingPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.java.ConstructorInfo"): typeof Internal.ConstructorInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage$ChainConveyorPackagePhysicsData"): typeof Internal.ChainConveyorPackage$ChainConveyorPackagePhysicsData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.SimplePreparableReloadListener"): typeof Internal.SimplePreparableReloadListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.data.SeaSerpent"): typeof Internal.SeaSerpent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Ravager"): typeof Internal.Ravager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.ChestBoat"): typeof Internal.ChestBoat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.items.VirtualPigment"): typeof Internal.VirtualPigment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.misc.WrappedGenericStack"): typeof Internal.WrappedGenericStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper"): typeof Internal.VoidUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.basin.BasinInventory"): typeof Internal.BasinInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.mixin.ui.layers.HandledScreenAccessor"): io.wispforest.owo.mixin.ui.layers.HandledScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.GuiAccessor"): com.simibubi.create.foundation.mixin.accessor.GuiAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.AxeItemBuilder"): typeof Internal.AxeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.logistics.Transfer"): typeof Internal.Transfer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS"): typeof Internal.AfterEntityFallenOnBlockCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Team"): typeof Internal.Team;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "wallywhip.resourcechickens.items.AnimalNet"): typeof Internal.AnimalNet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenSilverFluid$Source"): typeof Internal.MoltenSilverFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ClampedNormalFloat"): typeof Internal.ClampedNormalFloat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.item.SeedBagItem$BagSorter"): Internal.SeedBagItem$BagSorter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.IToolContext"): Internal.IToolContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fabric.CustomIngredientKJS"): Internal.CustomIngredientKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenZincFluid$Source"): typeof Internal.MoltenZincFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRespawnPacket"): typeof Internal.ClientboundRespawnPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.util.ThreeState"): typeof Internal.ThreeState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap"): typeof Internal.Long2ObjectLinkedOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.widget.TankWidget"): typeof Internal.TankWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.RenderTargetExtensions"): Internal.RenderTargetExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DropTargetDragEvent"): typeof Internal.DropTargetDragEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.vault.ItemVaultItem"): typeof Internal.ItemVaultItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry"): Internal.Object2FloatMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.AbstractCastingBlock"): typeof Internal.AbstractCastingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.Fluid"): typeof Internal.Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.IColorableBlockEntity"): Internal.IColorableBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.LiteralCommandNode"): typeof Internal.LiteralCommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup$IStyle"): Internal.BlockStateBlockItemGroup$IStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.model.baked.PartialModel"): typeof Internal.PartialModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GameEventListenerRenderer"): typeof Internal.GameEventListenerRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ArrowDamageEnchantment"): typeof Internal.ArrowDamageEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigParser"): com.electronwill.nightconfig.core.io.ConfigParser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool$Projection"): typeof Internal.StructureTemplatePool$Projection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.WorldshaperItem"): typeof Internal.WorldshaperItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.lucko.spark.fabric.mixin.MinecraftClientAccessor"): me.lucko.spark.fabric.mixin.MinecraftClientAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.NumberFormat$Style"): typeof Internal.NumberFormat$Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle040BogeyBlock"): typeof Internal.LargeCreateStyle040BogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.item.ModifiableStaffItem"): typeof Internal.ModifiableStaffItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "wallywhip.resourcechickens.items.XpItem"): typeof Internal.XpItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IInWorldGridNodeHost"): Internal.IInWorldGridNodeHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$ValueSet"): Internal.OptionInstance$ValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.player.AbstractClientPlayer"): typeof Internal.AbstractClientPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeepingVinesBlock"): typeof Internal.WeepingVinesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor.AbstractContainerMenuAccessor"): Internal.AbstractContainerMenuAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.util.ITintable"): Internal.ITintable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.head.DrinkingHatItem"): typeof Internal.DrinkingHatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.sounds.Music"): typeof Internal.Music;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.Format"): typeof Internal.Format;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.HoverEvent$EntityTooltipInfo"): typeof Internal.HoverEvent$EntityTooltipInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemAmphithereMacuahuitl"): typeof Internal.ItemAmphithereMacuahuitl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.EnumGetMethod"): typeof com.electronwill.nightconfig.core.EnumGetMethod;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.config.v2.types.GeneratorConfig"): typeof Internal.GeneratorConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour$TransportedResult"): typeof Internal.TransportedItemStackHandlerBehaviour$TransportedResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.CampfireBlockEntity"): typeof Internal.CampfireBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.StatsNBT"): typeof Internal.StatsNBT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleProvider"): Internal.ParticleProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.SharedSuggestionProvider$TextCoordinates"): typeof Internal.SharedSuggestionProvider$TextCoordinates;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.StandardBogeyBlock"): typeof Internal.StandardBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.TrackBuffer"): typeof Internal.TrackBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.ArgumentCommandNode"): typeof Internal.ArgumentCommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender"): typeof Internal.Blender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper"): typeof Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.api.inventory.LithiumInventory"): Internal.LithiumInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CaveWorldCarver"): typeof Internal.CaveWorldCarver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.server.CustomCommandEventJS"): typeof Internal.CustomCommandEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatFunction"): Internal.Object2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockBehaviour$OffsetFunction"): Internal.BlockBehaviour$OffsetFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockReturningState"): typeof Internal.BlockReturningState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.CompositeLootItemCondition$Builder"): typeof Internal.CompositeLootItemCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.PlayerRideable"): Internal.PlayerRideable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.context.BlockPlaceContext"): typeof Internal.BlockPlaceContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.modernfix.world.StrongholdLocationCache"): typeof Internal.StrongholdLocationCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.api.entity.BalmPlayer"): Internal.BalmPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.storage.ItemAbacus"): typeof Internal.ItemAbacus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.entity.pushable.BlockCachingEntity"): Internal.BlockCachingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.DateFormat"): typeof Internal.DateFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.gadgets.item.GlowBallItem"): typeof Internal.GlowBallItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.ChunkGeneratorStructureState"): typeof Internal.ChunkGeneratorStructureState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity$ThresholdType"): typeof Internal.ThresholdSwitchBlockEntity$ThresholdType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeColor"): typeof Internal.DyeColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HayBlock"): typeof Internal.HayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.common.recipe.BookRecipeSerializer"): typeof Internal.BookRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortList"): Internal.ShortList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.CompoundTag"): typeof Internal.CompoundTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Property$Value"): typeof Internal.Property$Value;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Shape"): Internal.Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ArrayList"): typeof Internal.ArrayList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText"): Internal.FormattedText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.FishingHook"): typeof Internal.FishingHook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.computer.core.ComputerState"): typeof Internal.ComputerState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.registry.SimpleRegistry"): Internal.SimpleRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.contact.RedstoneContactBlock"): typeof Internal.RedstoneContactBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.circles.impetuses.BlockRightClickImpetus"): typeof Internal.BlockRightClickImpetus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.AirItem"): typeof Internal.AirItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules"): typeof Internal.GameRules;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.inventories.InternalInventory"): Internal.InternalInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.equipment.potatoCannon.PotatoCannonProjectileType"): typeof Internal.PotatoCannonProjectileType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.kubejs.VeinRecipeJS"): typeof Internal.VeinRecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.LightLayer"): typeof Internal.LightLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.context.ToolAttackContext"): typeof Internal.ToolAttackContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.ContextMenu"): typeof Internal.ContextMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ReferenceFunction"): Internal.Reference2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GravelBlock"): typeof Internal.GravelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.worldgen.meteorite.MeteoriteStructure"): typeof Internal.MeteoriteStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.hoglin.Hoglin"): typeof Internal.Hoglin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MobSpawnType"): typeof Internal.MobSpawnType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.ScoreboardDisplaySource"): typeof Internal.ScoreboardDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.locks.ReadWriteLock"): Internal.ReadWriteLock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix2d"): typeof Internal.Matrix2d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.ConnectorType"): typeof Internal.ConnectorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.ContainerEntity"): Internal.ContainerEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.BooleanListIterator"): Internal.BooleanListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$ColorLogicStateShard"): typeof Internal.RenderStateShard$ColorLogicStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.ItemExtensions"): io.github.fabricators_of_create.porting_lib.extensions.extensions.ItemExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockItem"): typeof Internal.RedstoneRequesterBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockItemBuilder"): typeof Internal.BlockItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenZincFluid$Flowing"): typeof Internal.MoltenZincFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.TwistingVinesFeature"): typeof Internal.TwistingVinesFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.util.RegistryAccess$AccessibleRegistry"): Internal.RegistryAccess$AccessibleRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent"): typeof Internal.LivingAttackEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.AttachedActorBlock"): typeof Internal.AttachedActorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.feet.AquaDashersItem"): typeof Internal.AquaDashersItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packager.InventorySummary"): typeof Internal.InventorySummary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter"): Internal.VertexBufferWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.tree.MahoganyTreeFeature"): typeof Internal.MahoganyTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.ComponentPath"): Internal.ComponentPath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.SpriteContentsExtension"): Internal.SpriteContentsExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.ItemStackExtensions"): Internal.ItemStackExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$PrintQualityType"): typeof Internal.PageAttributes$PrintQualityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.render.RenderContext"): net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour$OccupiedPredicate"): Internal.DirectBeltInputBehaviour$OccupiedPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.Tesselator"): typeof Internal.Tesselator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.GeodeBlockSettings"): typeof Internal.GeodeBlockSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.component.RetexturedOrientableSmelteryBlock"): typeof Internal.RetexturedOrientableSmelteryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.AEBaseBlockEntity"): typeof Internal.AEBaseBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IStrictSignalTrain"): Internal.IStrictSignalTrain;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TooltipFlag"): Internal.TooltipFlag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.recipe.HeatCondition"): typeof Internal.HeatCondition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.NarrowTrackBufferBlock"): typeof Internal.NarrowTrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder"): typeof Internal.SodiumBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler"): typeof Internal.FilterItemStackHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2ShortFunction"): Internal.Double2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.IntSummaryStatistics"): typeof Internal.IntSummaryStatistics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.MobAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.MobAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.util.IDreadBlock"): Internal.IDreadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.WrappedExecutable"): Internal.WrappedExecutable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.modifiers.Modifier"): typeof Internal.Modifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.mixin.block.hopper.DefaultedListAccessor"): Internal.DefaultedListAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.element.ScreenElement"): Internal.ScreenElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem"): Internal.ReequipAnimationItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.HierarchyEvent"): typeof Internal.HierarchyEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cc.abbie.emi_ores.mixin.accessor.BlockStateMatchTestAccessor"): Internal.BlockStateMatchTestAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.common.LevelReaderMixin"): Internal.LevelReaderMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.behaviors.GenericInternalInventory"): Internal.GenericInternalInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2FloatFunction"): Internal.Char2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent"): typeof Internal.SoundKeyframeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.ChatType"): typeof Internal.ChatType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch"): typeof Internal.ModifierMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_tracks.phantom.PhantomTrackBlock"): typeof Internal.PhantomTrackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.SpriteContentsInvoker"): Internal.SpriteContentsInvoker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BooleanProperty"): typeof Internal.BooleanProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.attributefix.mixin.AccessorRangedAttribute"): Internal.AccessorRangedAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.RootedStumpFeature"): typeof Internal.RootedStumpFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Insets"): typeof Internal.Insets;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.ResultConsumer"): Internal.ResultConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.station.GlobalPackagePort"): typeof Internal.GlobalPackagePort;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute$Type"): typeof Internal.AddedByAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket"): typeof Internal.ServerboundMoveVehiclePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType"): typeof Internal.ExtendedScreenHandlerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsServerList"): typeof Internal.RealmsServerList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.RecipeBookType"): typeof Internal.RecipeBookType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceArgument$Info"): typeof Internal.ResourceArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientChunkCache"): typeof Internal.ClientChunkCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.tree.CypressTreeFeature"): typeof Internal.CypressTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2LongFunction"): Internal.Int2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ObjectFunction"): Internal.Reference2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.util.nullness.NonNullBiConsumer"): Internal.NonNullBiConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain"): Internal.IBufferBlockedTrain;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.materials.ExperienceNuggetItem"): typeof Internal.ExperienceNuggetItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.MobEffectExtensions"): io.github.fabricators_of_create.porting_lib.extensions.extensions.MobEffectExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ButtonBlock"): typeof Internal.ButtonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock"): typeof Internal.ConnectedGlassPaneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.fantastic.ParticleRenderingPhase"): typeof Internal.ParticleRenderingPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.ReplacementMatch"): Internal.ReplacementMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.part.MaterialItem"): typeof Internal.MaterialItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.tr7zw.skinlayers.accessor.NativeImageAccessor"): dev.tr7zw.skinlayers.accessor.NativeImageAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemBuilder"): typeof Internal.ItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder"): Internal.ExtendedBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.peripheral.monitor.MonitorBlock"): typeof Internal.MonitorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "wallywhip.resourcechickens.items.ManureItem"): typeof Internal.ManureItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.api.linkable.LinkableRegistry$LinkableType"): typeof Internal.LinkableRegistry$LinkableType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TravellingPoint$ITurnListener"): Internal.TravellingPoint$ITurnListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.blocks.MageBlock$Companion"): typeof Internal.MageBlock$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.WorldlyContainer"): Internal.WorldlyContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer"): typeof Internal.SpruceFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.requirement.ItemRequirement$ItemUseType"): typeof Internal.ItemRequirement$ItemUseType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.particles.ConjureParticleOptions"): typeof Internal.ConjureParticleOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.prestidigitation.SquirtSquidsEffect"): typeof Internal.SquirtSquidsEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ArrowItem"): typeof Internal.ArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.ItemCyclopsEye"): typeof Internal.ItemCyclopsEye;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation"): Internal.IHaveGoggleInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket"): typeof Internal.ClientboundSetActionBarTextPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration"): typeof Internal.SimpleRandomFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ChorusFlowerBlock"): typeof Internal.ChorusFlowerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.PacketFlow"): typeof Internal.PacketFlow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.necklace.CharmOfSinkingItem"): typeof Internal.CharmOfSinkingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.trinkets.api.SlotType"): typeof dev.emi.trinkets.api.SlotType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.ItemAccessor"): Internal.ItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.FrameType"): typeof Internal.FrameType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.tropheusj.milk.MilkFluidBlock"): typeof Internal.MilkFluidBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge"): typeof Internal.BlockEntityDragonForge;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BaseFireBlock"): typeof Internal.BaseFireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket"): typeof Internal.ClientboundBlockUpdatePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.SingletonArgumentInfo$Template"): typeof Internal.SingletonArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.HeightProvider"): typeof Internal.HeightProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownEnderpearl"): typeof Internal.ThrownEnderpearl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ShortFunction"): Internal.Char2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.InputFluid"): Internal.InputFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.common.tileentities.TileExDrive"): typeof Internal.TileExDrive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.AEBaseInvBlockEntity"): typeof Internal.AEBaseInvBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.TimeComponent"): typeof Internal.TimeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.storage.ItemFocus"): typeof Internal.ItemFocus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Marker"): typeof Internal.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.base.Wrenchable"): Internal.Wrenchable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorAbstractContraptionEntity"): Internal.AccessorAbstractContraptionEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.RotationAxis"): typeof RotationAxis;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase"): typeof Internal.EnderDragonPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.recipe.CustomShapedRecipe"): typeof Internal.CustomShapedRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.player.LocalPlayer"): typeof Internal.LocalPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.IronBarsBlock"): typeof Internal.IronBarsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.spout.SpoutBlockEntity"): typeof Internal.SpoutBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.PackOutput$PathProvider"): typeof Internal.PackOutput$PathProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.items.HextitoItem"): typeof Internal.HextitoItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.sequenced.IAssemblyRecipe"): Internal.IAssemblyRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions"): Internal.ParticleOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.WritableLevelData"): Internal.WritableLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationProcessor$QueuedAnimation"): typeof Internal.AnimationProcessor$QueuedAnimation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.Animation$LoopType"): Internal.Animation$LoopType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe"): typeof Internal.EntityMeltingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ContainerListener"): net.minecraft.world.ContainerListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.EntropyManipulatorItem"): typeof Internal.EntropyManipulatorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.CombatTracker"): typeof Internal.CombatTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.GlobalPos"): typeof Internal.GlobalPos;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.AttackIndicatorStatus"): typeof Internal.AttackIndicatorStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.EntryGroup$Builder"): typeof Internal.EntryGroup$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.pathing.IPathingService"): Internal.IPathingService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.bossevents.CustomBossEvents"): typeof Internal.CustomBossEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.DoubleAxleBogeyBlock"): typeof Internal.DoubleAxleBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.EndCrystal"): typeof Internal.EndCrystal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Pair$Mu"): typeof Internal.Pair$Mu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.builders.BuilderCallback"): Internal.BuilderCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.CommandSyntaxException"): typeof Internal.CommandSyntaxException;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.logistics.energy.Energy"): typeof Internal.Energy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.Accessible"): Internal.Accessible;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor"): Internal.IUpgradeWrapperAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.ChronoUnit"): typeof Internal.ChronoUnit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.smokestack.block.be.DieselSmokeStackBlockEntity"): typeof Internal.DieselSmokeStackBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry"): typeof Internal.LightSourceSettingEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.DamageType"): typeof Internal.DamageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.IntPredicate"): Internal.IntPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.GuiMessage$Line"): typeof Internal.GuiMessage$Line;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LadderBlock"): typeof Internal.LadderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.EnchantmentCategory"): typeof Internal.EnchantmentCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.BuilderType"): typeof Internal.BuilderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe$Serializer"): typeof Internal.MaterialCastingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.BooleanConsumer"): it.unimi.dsi.fastutil.booleans.BooleanConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ComparatorBlock"): typeof Internal.ComparatorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.PiglinWallHeadBlock"): typeof Internal.PiglinWallHeadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAwardStatsPacket"): typeof Internal.ClientboundAwardStatsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.storage.cells.ICellWorkbenchItem"): Internal.ICellWorkbenchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ShulkerBullet"): typeof Internal.ShulkerBullet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.fluids.SlimeFluid$Flowing"): typeof Internal.SlimeFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest"): typeof Internal.BlockMatchTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration$Layer"): typeof Internal.BlockColumnConfiguration$Layer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockExtensions"): io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe$Serializer"): typeof Internal.CompositeCastingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.batchedentityrendering.impl.BlendingStateHolder"): Internal.BlendingStateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.User$Type"): typeof Internal.User$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.blocks.GlobeBlock"): typeof Internal.GlobeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.DataGenContext"): typeof Internal.DataGenContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig"): typeof Internal.NetherForestVegetationConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ShortFunction"): Internal.Object2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.KelpRollItem"): typeof Internal.KelpRollItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.energy.base.EnergyContainer"): Internal.EnergyContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ComponentValueMap"): typeof Internal.ComponentValueMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonDeserializationContext"): Internal.JsonDeserializationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator$OfPrimitive"): Internal.Spliterator$OfPrimitive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.zestyblaze.lootr.block.LootrInventoryBlock"): typeof Internal.LootrInventoryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.sounds.TickableSoundInstance"): Internal.TickableSoundInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorCarriage"): Internal.AccessorCarriage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BedItem"): typeof Internal.BedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2LongFunction"): Internal.Float2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket"): typeof Internal.ClientboundHorseScreenOpenPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.signal.SignalBlock$SignalType"): typeof Internal.SignalBlock$SignalType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.kubejs.ExtractorRecipeJS"): typeof Internal.ExtractorRecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4f"): typeof Vec4f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.block.CustomLandingEffectsBlock"): Internal.CustomLandingEffectsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.client.AccessorEntity"): Internal.AccessorEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.StandingAndWallBlockItem"): typeof Internal.StandingAndWallBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents$KnockBackStrength"): Internal.LivingEntityEvents$KnockBackStrength;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationAccessor"): me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenBismuthFluid$Flowing"): typeof Internal.MoltenBismuthFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelResource"): typeof Internal.LevelResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.creative_energy.CreativeEnergyBlockEntity"): typeof Internal.CreativeEnergyBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.java.MethodInfo$ParamInfo"): typeof Internal.MethodInfo$ParamInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.NixieTubeDisplaySource"): typeof Internal.NixieTubeDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.util.IOBlockType"): typeof Internal.IOBlockType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.JigsawStructure"): typeof Internal.JigsawStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Tiers"): typeof Internal.Tiers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorCarriageContraptionEntity"): Internal.AccessorCarriageContraptionEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket"): typeof Internal.ClientboundMoveVehiclePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.RecipeKJS"): Internal.RecipeKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleUnaryOperator"): Internal.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGridService"): Internal.IGridService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.InteractionResultHolder"): typeof Internal.InteractionResultHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.LevelRendererAccessor"): com.simibubi.create.foundation.mixin.accessor.LevelRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.inventories.ISegmentedInventory"): Internal.ISegmentedInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory"): Internal.TypeWrapperFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.MonoTrackBufferBlock"): typeof Internal.MonoTrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TippedArrowItem"): typeof Internal.TippedArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ArmorMaterial"): Internal.ArmorMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ParticleEngineAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ParticleEngineAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.control.Control"): Internal.Control;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.CommandBuildContext"): Internal.CommandBuildContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.magic.ItemMediaBattery"): typeof Internal.ItemMediaBattery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.patternprovider.PatternContainer"): Internal.PatternContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.pattern.BlockInWorld"): typeof Internal.BlockInWorld;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.menuobjects.IPortableTerminal"): Internal.IPortableTerminal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MelonBlock"): typeof Internal.MelonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemModShovel"): typeof Internal.ItemModShovel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CryingObsidianBlock"): typeof Internal.CryingObsidianBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues"): Internal.IBlacklistedFromStatues;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.BlockUtil$FoundRectangle"): typeof Internal.BlockUtil$FoundRectangle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.IcebergFeature"): typeof Internal.IcebergFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.regex.Matcher"): typeof Internal.Matcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.AbstractCraftingUnitBlock"): typeof Internal.AbstractCraftingUnitBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriRequirement"): typeof Internal.AgriRequirement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialSteps"): typeof Internal.TutorialSteps;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.transform.Scale"): Internal.Scale;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.palettes.boiler.BoilerBlock$Style"): typeof Internal.BoilerBlock$Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList"): typeof Internal.FluidContainerList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.RecipeSchema"): typeof Internal.RecipeSchema;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.computer.WandTurtleUpgrade$UpgradeSerializer"): typeof Internal.WandTurtleUpgrade$UpgradeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.HumanoidModel$ArmPose"): typeof Internal.HumanoidModel$ArmPose;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe$Serializer"): typeof Internal.MaterialFluidRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.Contraption"): typeof Internal.Contraption;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.flywheel.FlywheelBlockEntity"): typeof Internal.FlywheelBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.CableBusBlock"): typeof Internal.CableBusBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer"): typeof Internal.DarkOakFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidBuilder"): typeof Internal.FluidBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.TypedOptic$Element"): typeof Internal.TypedOptic$Element;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.ModelBakery"): typeof Internal.ModelBakery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.DimensionSpecialEffectsExtensions"): Internal.DimensionSpecialEffectsExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.MobEffectInstanceAccessor"): Internal.MobEffectInstanceAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.Chronology"): Internal.Chronology;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.GlowInkSacItem"): typeof Internal.GlowInkSacItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ItemKJS"): Internal.ItemKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexFormat"): typeof Internal.VertexFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.BlockConjuredLight"): typeof Internal.BlockConjuredLight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleRole"): typeof Internal.AccessibleRole;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.event.EventFactory$EventImpl"): typeof Internal.EventFactory$EventImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.fluids.PortingLibFluids$1"): typeof Internal.PortingLibFluids$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity"): typeof Internal.ToolboxBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.AbuseReportLimits"): typeof Internal.AbuseReportLimits;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Dolphin"): typeof Internal.Dolphin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Hashtable"): typeof Internal.Hashtable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.Delayed"): Internal.Delayed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.IMergeableBE"): Internal.IMergeableBE;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.onyxstudios.cca.mixin.level.common.MixinWorldProperties"): Internal.MixinWorldProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2FloatFunction"): Internal.Boolean2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.KeyFrameEvent"): typeof Internal.KeyFrameEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.PBRType"): typeof Internal.PBRType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.prestidigitation.NoteblockEffect"): typeof Internal.NoteblockEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.controlling.mixin.AccessKeyMapping"): Internal.AccessKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.CreativeEnergyCellBlock"): typeof Internal.CreativeEnergyCellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.properties.PropertyMap"): typeof Internal.PropertyMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.networking.SimplePacketBase"): typeof Internal.SimplePacketBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.toolbox.ToolboxMountedStorageType"): typeof Internal.ToolboxMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongUnaryOperator"): Internal.LongUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.FenceGateBlockBuilder"): typeof Internal.FenceGateBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.FireChargeItem"): typeof Internal.FireChargeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler$ConnectedInput"): typeof Internal.ConnectedInputHandler$ConnectedInput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.uranus.object.item.CustomArmorMaterial"): typeof Internal.CustomArmorMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.SingletonArgumentInfo"): typeof Internal.SingletonArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.syncher.SynchedEntityData"): typeof Internal.SynchedEntityData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.clock.CuckooClockBlockEntity$Animation"): typeof Internal.CuckooClockBlockEntity$Animation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ComponentKJS"): Internal.ComponentKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeNyliumBlock"): typeof Internal.SlimeNyliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Saddleable"): Internal.Saddleable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.w3c.dom.UserDataHandler"): Internal.UserDataHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.RegistryCallback"): Internal.RegistryCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.FormattedCharSink"): Internal.FormattedCharSink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService"): typeof Internal.YggdrasilAuthenticationService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.suggestion.Suggestions"): typeof Internal.Suggestions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuContainer"): Internal.MenuContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.pepperbell.simplenetworking.Packet"): me.pepperbell.simplenetworking.Packet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.InfiniteArrowItem"): Internal.InfiniteArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot"): typeof Internal.ItemStackHandlerSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeWartBlock"): typeof Internal.SlimeWartBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.single_deco.GenericDyeableSingleBufferBlock"): typeof Internal.GenericDyeableSingleBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTooltipEventJS"): typeof Internal.ItemTooltipEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.TransientEntitySectionManager"): typeof Internal.TransientEntitySectionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.mixin.accessors.MobAccessor"): Internal.MobAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.spec.AlgorithmParameterSpec"): Internal.AlgorithmParameterSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent$Factory"): Internal.DynamicRecipeComponent$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer$Inventory"): Internal.IMultiBlockEntityContainer$Inventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenEvents$Remove"): Internal.ScreenEvents$Remove;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.impl.mixin.ModelPartAccessor"): Internal.ModelPartAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagManager"): typeof Internal.TagManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3x2dc"): Internal.Matrix3x2dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.casting.actions.stack.SpecialHandlerMask$Companion"): typeof Internal.SpecialHandlerMask$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Collections$SynchronizedMap"): typeof Internal.Collections$SynchronizedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.items.ItemRelay"): typeof Internal.ItemRelay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.Visibility"): typeof Internal.Visibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntBinaryOperator"): it.unimi.dsi.fastutil.ints.IntBinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.ratatouille.block.PlushBlock"): typeof Internal.PlushBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe"): Internal.ITinkerStationRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SolidBucketItem"): typeof Internal.SolidBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo"): typeof Internal.RenderInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemClickedEventJS"): typeof Internal.ItemClickedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.ReportingContext"): typeof Internal.ReportingContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.smokestack.block.FacingSmokeStackBlock"): typeof Internal.FacingSmokeStackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.BindingCurseEnchantment"): typeof Internal.BindingCurseEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionProgress"): typeof Internal.CriterionProgress;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket"): typeof Internal.ClientboundCommandSuggestionsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.WorldGenRegion"): typeof Internal.WorldGenRegion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage"): typeof Internal.ModifierSalvage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade"): Internal.IOverflowResponseUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundTabListPacket"): typeof Internal.ClientboundTabListPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "virtuoel.pehkui.api.ScaleModifier"): typeof Internal.ScaleModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.StandardTrackBufferBlock"): typeof Internal.StandardTrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemHydraArrow"): typeof Internal.ItemHydraArrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleAction"): Internal.AccessibleAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SculkSpreader$ChargeCursor"): typeof Internal.SculkSpreader$ChargeCursor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.item.PrimedTnt"): typeof Internal.PrimedTnt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.LargeConnectorBlock"): typeof Internal.LargeConnectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.MusicManager"): typeof Internal.MusicManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerData"): typeof Internal.VillagerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.FireworkRocketItem"): typeof Internal.FireworkRocketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockModificationEventJS"): typeof Internal.BlockModificationEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.depot.storage.DepotMountedStorageType"): typeof Internal.DepotMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.impl.animation.AnimationApplier"): typeof Internal.AnimationApplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.infrastructure.worldgen.LayerPattern$Builder"): typeof Internal.LayerPattern$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.Ops"): typeof Internal.Ops;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight"): typeof Internal.TrapezoidHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ui.SelectableResource"): Internal.SelectableResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem"): typeof Internal.ToolSwapperUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.peripheral.modem.wired.CableBlock"): typeof dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.sounds.SoundEvent"): typeof Internal.SoundEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.AbuseReportSender"): Internal.AbuseReportSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerAdvancementManager"): typeof Internal.ServerAdvancementManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour$InsertionCallback"): Internal.DirectBeltInputBehaviour$InsertionCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.casting.actions.math.SpecialHandlerNumberLiteral$Factory"): typeof Internal.SpecialHandlerNumberLiteral$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$ConfigValue"): typeof Internal.ForgeConfigSpec$ConfigValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.quartz.QuartzWrenchItem"): typeof Internal.QuartzWrenchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.casting.iota.RitualIota"): typeof Internal.RitualIota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.FluidConfig"): typeof Internal.FluidConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.StructBuffer"): typeof Internal.StructBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.cannon.MaterialChecklist"): typeof Internal.MaterialChecklist;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.util.entry.BlockEntry"): typeof Internal.BlockEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.ICraftingService"): Internal.ICraftingService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.block.WeatheringPlatformBlock"): typeof Internal.WeatheringPlatformBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.poi.PoiManager"): typeof Internal.PoiManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.DayOfWeek"): typeof Internal.DayOfWeek;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup"): typeof Internal.UpgradeGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket"): typeof Internal.ClientboundPlaceGhostRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DropTargetDropEvent"): typeof Internal.DropTargetDropEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.presets.WorldPreset"): typeof Internal.WorldPreset;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.item.DragonScaleItem"): typeof Internal.DragonScaleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P16"): typeof Internal.Products$P16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.BrickPipeBlock"): typeof Internal.BrickPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.color.SimpleColor"): typeof Internal.SimpleColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.NozzleBlockEntity"): typeof Internal.NozzleBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.recipe.FreezeRecipe$Serializer"): typeof Internal.FreezeRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket"): typeof Internal.ServerboundRecipeBookSeenRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenBismuthFluid"): typeof Internal.MoltenBismuthFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.PiglinsNeutralItem"): Internal.PiglinsNeutralItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEvent$Context"): typeof Internal.GameEvent$Context;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.StackedContents"): typeof Internal.StackedContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeManager$NoiseBiomeSource"): Internal.BiomeManager$NoiseBiomeSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Husk"): typeof Internal.Husk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour$TankSegment"): typeof Internal.SmartFluidTankBehaviour$TankSegment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.mixin.accessor.FluidBlockAccessor"): Internal.FluidBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.utils.RestrictedCompoundTag"): typeof Internal.RestrictedCompoundTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.config.ConfigBase$CValue"): typeof Internal.ConfigBase$CValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fi.dy.masa.litematica.mixin.IMixinRedstoneWireBlock"): Internal.IMixinRedstoneWireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.PushDirection"): typeof Internal.PushDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.HolderLookup$Provider"): Internal.HolderLookup$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.ChestBlockEntity"): typeof Internal.ChestBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.FileNotFoundAction"): com.electronwill.nightconfig.core.file.FileNotFoundAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter"): typeof Internal.SurfaceRelativeThresholdFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Sheep"): typeof Internal.Sheep;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2FloatFunction"): Internal.Reference2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.IExtendedItem"): Internal.IExtendedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.xplat.XplatModContainer"): Internal.XplatModContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.RoundingMode"): typeof Internal.RoundingMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType"): typeof Internal.UpgradeType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.menu.MenuRegistry$ScreenFactory"): Internal.MenuRegistry$ScreenFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.AdvancedCopperFluidPipeBlock"): typeof Internal.AdvancedCopperFluidPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockDreadPortal"): typeof Internal.BlockDreadPortal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.CutoutShader"): Internal.CutoutShader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.pattern.BlockPattern"): typeof Internal.BlockPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.recipe.HexalRecipeTypes$Companion$registerType$type$1"): typeof Internal.HexalRecipeTypes$Companion$registerType$type$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Queue"): Internal.Queue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.comforts.common.item.SleepingBagItem"): typeof Internal.SleepingBagItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.lang.LangBuilder"): typeof Internal.LangBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.recipe.EnchantmentConvertingRecipe$Serializer"): typeof Internal.EnchantmentConvertingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TrainStatus$StatusMessage"): typeof Internal.TrainStatus$StatusMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.arsenal.enchantment.UniqueEnchantment"): Internal.UniqueEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.CustomMapData$Type"): typeof Internal.CustomMapData$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper"): typeof Internal.MountedItemStorageWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerInputPacket"): typeof Internal.ServerboundPlayerInputPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute"): Internal.IDragonFlute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockGraveyardSoil"): typeof Internal.BlockGraveyardSoil;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SignText"): typeof Internal.SignText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.onyxstudios.cca.mixin.scoreboard.TeamAccessor"): Internal.TeamAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.IceBlock"): typeof Internal.IceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedRandomList"): typeof Internal.WeightedRandomList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Shader"): Internal.Shader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenGoldFluid$Source"): typeof Internal.MoltenGoldFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.helper.LoggingRecipeSerializer"): typeof Internal.LoggingRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.ConstProperties"): Internal.ConstProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.geom.Line2D"): typeof Internal.Line2D;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.Navigation"): typeof Internal.Navigation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.item.AgriSeedItem"): typeof Internal.AgriSeedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.recipe.DragonForgeRecipe$Serializer"): typeof Internal.DragonForgeRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Rarity"): typeof Internal.Rarity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.core.util.Vec3f"): typeof Internal.Vec3f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour$ProcessingCallback"): Internal.BeltProcessingBehaviour$ProcessingCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.pathfinder.BlockPathTypes"): typeof Internal.BlockPathTypes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData"): typeof Internal.ClientboundLightUpdatePacketData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EnumSet"): typeof Internal.EnumSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.EnergyGeneratorBlock"): typeof Internal.EnergyGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.component.OrientableSmelteryBlock"): typeof Internal.OrientableSmelteryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.FluidAmountDisplaySource"): typeof Internal.FluidAmountDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.mixin.texture.SpriteContentsTickerAccessor"): Internal.SpriteContentsTickerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.context.StringRange"): typeof Internal.StringRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuItem"): Internal.SpectatorMenuItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.api.IPage"): Internal.IPage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.LightningBolt"): typeof Internal.LightningBolt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentMap"): Internal.ConcurrentMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.logistics.fluid.Tank"): typeof Internal.Tank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.util.DimChunkPos"): typeof Internal.DimChunkPos;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.iota.Vec3Iota"): typeof Internal.Vec3Iota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.datagen.v1.loot.FabricBlockLootTableGenerator"): Internal.FabricBlockLootTableGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.onyxstudios.cca.api.v3.component.ComponentKey"): typeof Internal.ComponentKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationFrameAccessor"): Internal.SpriteContentsAnimationFrameAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.narration.NarratableEntry"): Internal.NarratableEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.SimpleDateFormat"): typeof Internal.SimpleDateFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.DataResult"): typeof Internal.DataResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor"): me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo"): typeof net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.station.StationMarker"): typeof Internal.StationMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable"): Internal.MagnifyingInspectable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents$PlayerBreakSpeed"): Internal.PlayerEvents$PlayerBreakSpeed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.PackCompatibility"): typeof Internal.PackCompatibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapCodec$MapCodecCodec"): typeof Internal.MapCodec$MapCodecCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.atomic.AtomicReferenceArray"): typeof Internal.AtomicReferenceArray;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.PersistentEntitySectionManager"): typeof Internal.PersistentEntitySectionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectSortedSet"): Internal.ObjectSortedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.ArmorStand"): typeof Internal.ArmorStand;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.belt.CloudInABottleItem"): typeof Internal.CloudInABottleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket$ChunkBiomeData"): typeof Internal.ClientboundChunksBiomesPacket$ChunkBiomeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.ChatListener"): typeof Internal.ChatListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.storage.ItemSlate"): typeof Internal.ItemSlate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.trading.MerchantOffer"): typeof Internal.MerchantOffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.viewport.Viewport"): typeof Internal.Viewport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.items.armor.base.CustomDyeableArmorItem"): typeof Internal.CustomDyeableArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.data.TrollType"): typeof Internal.TrollType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS"): typeof Internal.PrimitiveDescJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$_Simple"): typeof Internal.WidgetLayout$_Simple;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BlockColumnFeature"): typeof Internal.BlockColumnFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.models.generators.CustomLoaderBuilder"): typeof Internal.CustomLoaderBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer"): typeof Internal.RecipeWrapperSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeightedPressurePlateBlock"): typeof Internal.WeightedPressurePlateBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ObjectMap$Entry"): Internal.Object2ObjectMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock"): typeof Internal.CopycatHeadstockBarsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.ICraftingMachine"): Internal.ICraftingMachine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade"): Internal.IFluidHandlerWrapperUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.Explosion"): typeof Internal.Explosion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ScoreHolderArgument"): typeof Internal.ScoreHolderArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.TidepoolFeature"): typeof Internal.TidepoolFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.widget.ButtonWidget$ClickAction"): Internal.ButtonWidget$ClickAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.instance.Instance"): Internal.Instance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.PiglinBruteSpecificSensor"): typeof Internal.PiglinBruteSpecificSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.regex.Pattern"): typeof Internal.Pattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IPreAssembleCallback"): Internal.IPreAssembleCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.ModifierNBT"): typeof Internal.ModifierNBT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.StyleConstants$CharacterConstants"): typeof Internal.StyleConstants$CharacterConstants;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.ICrankable"): Internal.ICrankable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.MinecraftProfileTexture$Type"): typeof Internal.MinecraftProfileTexture$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl"): typeof Internal.CustomIngredientImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.tool.CardboardSwordItem"): typeof Internal.CardboardSwordItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerFunctionLibrary"): typeof Internal.ServerFunctionLibrary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.storage.CreativeCellItem"): typeof Internal.CreativeCellItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.main.GameConfig$FolderData"): typeof Internal.GameConfig$FolderData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.synth.NormalNoise$NoiseParameters"): typeof Internal.NormalNoise$NoiseParameters;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.api.EnvType"): typeof Internal.EnvType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.filter.FilterItemStack"): typeof Internal.FilterItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Either$Mu"): typeof Internal.Either$Mu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.navigation.ScreenRectangle"): typeof Internal.ScreenRectangle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.util.StorageProvider"): typeof Internal.StorageProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animatable.model.CoreGeoModel"): Internal.CoreGeoModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$ShaderStateShard"): typeof Internal.RenderStateShard$ShaderStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.ConstantHeight"): typeof Internal.ConstantHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier$EasingFunction"): Internal.AbstractFadeModifier$EasingFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid"): typeof Internal.SoftFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Result"): Internal.ResourceOrTagKeyArgument$Result;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.common.items.ItemWirelessConnectTool"): typeof Internal.ItemWirelessConnectTool;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ItemComponents$3"): typeof Internal.ItemComponents$3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.misc.CellWorkbenchBlock"): typeof Internal.CellWorkbenchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.tinkerstation.repairing.SpecializedRepairRecipeSerializer$ISpecializedRepairRecipe"): Internal.SpecializedRepairRecipeSerializer$ISpecializedRepairRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.vertices.BlockSensitiveBufferBuilder"): Internal.BlockSensitiveBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.BitSet"): typeof Internal.BitSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.comforts.common.item.HammockItem"): typeof Internal.HammockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.resource.loader.FabricResource"): Internal.FabricResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.WorldCreationContext"): typeof Internal.WorldCreationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.IScreenWrapper"): Internal.IScreenWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.robdog777.enchantmentsplus.enchants.CubicalEnchantment"): typeof Internal.CubicalEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.digital_adapter.DigitalAdapterBlock"): typeof Internal.DigitalAdapterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.AmbientMoodSettings"): typeof Internal.AmbientMoodSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAddPlayerPacket"): typeof Internal.ClientboundAddPlayerPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec"): Internal.Codec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.glodblock.extendedae.common.items.tools.ItemWirelessExPAT"): typeof Internal.ItemWirelessExPAT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.recipes.entropy.EntropyRecipe"): typeof Internal.EntropyRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket"): typeof Internal.ClientboundSetSimulationDistancePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.SuspiciousStewItemAccessor"): Internal.SuspiciousStewItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.IntProviderType"): Internal.IntProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigWriter"): com.electronwill.nightconfig.core.io.ConfigWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.TextureAtlasSprite$AnimatedTextureAccessor"): Internal.TextureAtlasSprite$AnimatedTextureAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGrid"): Internal.IGrid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type"): typeof com.mojang.datafixers.types.Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundlerInfo$Provider"): Internal.BundlerInfo$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.SwiftSneakEnchantment"): typeof Internal.SwiftSneakEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jdk.internal.foreign.layout.AbstractLayout"): typeof Internal.AbstractLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2IntFunction"): Internal.Int2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.document.DocumentMethod"): typeof Internal.DocumentMethod;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.FluidRecipeWrapper"): typeof Internal.FluidRecipeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.display.FlapDisplayLayout"): typeof Internal.FlapDisplayLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.storage.cells.StorageCell"): Internal.StorageCell;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.FallenBirchLogFeature"): typeof Internal.FallenBirchLogFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.FallingBlockEntityAccessor"): Internal.FallingBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.client.handler.IHudItem"): Internal.IHudItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity"): typeof Internal.PoweredShaftBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.necklace.ThornPendantItem"): typeof Internal.ThornPendantItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension"): Internal.OwoEntityRenderDispatcherExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk"): typeof Internal.ChunkRenderDispatcher$RenderChunk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.CarriageSyncData"): typeof Internal.CarriageSyncData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.qnb.QuantumBaseBlock"): typeof Internal.QuantumBaseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier"): Internal.RuleBlockEntityModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.Block"): typeof Internal.Block;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.element.RenderElement"): Internal.RenderElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListener$Holder"): Internal.GameEventListener$Holder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexSorting"): Internal.VertexSorting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.ItemJewelerHammer"): typeof Internal.ItemJewelerHammer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.MinecraftRemapper"): typeof Internal.MinecraftRemapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.tropheusj.serialization_hooks.ingredient.CombinedIngredient$Deserializer"): typeof Internal.CombinedIngredient$Deserializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.LumaloopPlantBlock"): typeof Internal.LumaloopPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionTriggerInstance"): Internal.CriterionTriggerInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationController"): typeof Internal.AnimationController;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap"): typeof Internal.AbstractLong2ObjectMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.NBTIOWrapper"): NBTIO;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.client.render.effects.LightningArcParticleData"): typeof Internal.LightningArcParticleData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.world.features.InfernalSpireColumnFeature"): typeof Internal.InfernalSpireColumnFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.math.PixelBuffer"): typeof Internal.PixelBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.mixin.accessor.client.AccessorEmptyTextureStateShard"): Internal.AccessorEmptyTextureStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2ReferenceFunction"): Internal.Float2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.AndRecipeComponent"): typeof Internal.AndRecipeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.NameMap$Builder"): typeof Internal.NameMap$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.data.delegate.DragonForgePropertyDelegate"): typeof Internal.DragonForgePropertyDelegate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.batchedentityrendering.impl.MemoryTrackingBuffer"): Internal.MemoryTrackingBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.eval.vm.FrameFinishEval$TYPE$1"): typeof Internal.FrameFinishEval$TYPE$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure"): typeof Internal.MineshaftStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Dialog$ModalityType"): typeof Internal.Dialog$ModalityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.network.IObserveTileEntity"): Internal.IObserveTileEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Llama$Variant"): typeof Internal.Llama$Variant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.LampBase"): typeof Internal.LampBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent"): Internal.ClientTooltipComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder"): typeof Internal.FabricEntityTypeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.InputMethodEvent"): typeof Internal.InputMethodEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.BooleanIterator"): Internal.BooleanIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleListIterator"): Internal.DoubleListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Info"): typeof Internal.ResourceOrTagKeyArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.PickaxeItem"): typeof Internal.PickaxeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.BossHealthOverlay"): typeof Internal.BossHealthOverlay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.storage.ChestBlock"): typeof appeng.block.storage.ChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.items.TchotchkeItem"): typeof Internal.TchotchkeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.entities.multipart.MultipartPartsHolder"): Internal.MultipartPartsHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.recipe.ProcessingInventory"): typeof Internal.ProcessingInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTooltipEventJS$StaticTooltipHandlerFromJS"): Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.MessageSignature$Packed"): typeof Internal.MessageSignature$Packed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.mixinterface.ExtendedBiome"): Internal.ExtendedBiome;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.TrackTargetingBlockItem$OverlapResult"): typeof Internal.TrackTargetingBlockItem$OverlapResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.robdog777.enchantmentsplus.enchants.LevitationEnchantment"): typeof Internal.LevitationEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.graph.TrackEdgeIntersection"): typeof Internal.TrackEdgeIntersection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity"): net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.CompletionStage"): Internal.CompletionStage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Cod"): typeof Internal.Cod;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemTrollWeapon"): typeof Internal.ItemTrollWeapon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.transport.BeltMovementHandler$TransportedEntityInfo"): typeof Internal.BeltMovementHandler$TransportedEntityInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockCharedPath"): typeof Internal.BlockCharedPath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory"): Internal.SpecialLogicInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.ShaderInstance"): typeof Internal.ShaderInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager"): Internal.AccessorRecipeManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.CongealedSlimeBlock"): typeof Internal.CongealedSlimeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visualization.EntityVisualizer"): Internal.EntityVisualizer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType"): typeof Internal.TrunkPlacerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.w3c.dom.DocumentFragment"): Internal.DocumentFragment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ModCheck"): typeof Internal.ModCheck;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.loot.v1.FabricLootSupplier"): Internal.FabricLootSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity"): typeof Internal.RedstoneLinkBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.fluids.SlimeFluid$Source"): typeof Internal.SlimeFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignedMessageBody$Packed"): typeof Internal.SignedMessageBody$Packed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap"): typeof Internal.Object2FloatOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SortedMap"): Internal.SortedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.LinkedList"): typeof Internal.LinkedList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Position"): Internal.Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.HugeGlowshroomFeature"): typeof Internal.HugeGlowshroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.EnderChestBlock"): typeof Internal.EnderChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IFacadeContainer"): Internal.IFacadeContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AbstractCandleBlock"): typeof Internal.AbstractCandleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.transfer.v1.item.ItemVariant"): Internal.ItemVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$BeardifierOrMarker"): Internal.DensityFunctions$BeardifierOrMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.eval.vm.FrameForEach"): typeof Internal.FrameForEach;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.block.entity.ExcavatingBlockEntityImpl"): typeof Internal.ExcavatingBlockEntityImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundGameEventPacket$Type"): typeof Internal.ClientboundGameEventPacket$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockItem"): typeof Internal.ModularAccumulatorBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.PBRAtlasHolder"): typeof Internal.PBRAtlasHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.core.metrics.Metric$Counter"): typeof Internal.Metric$Counter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.context.ToolHarvestContext"): typeof Internal.ToolHarvestContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffectInstance"): typeof Internal.MobEffectInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.AEBaseItem"): typeof Internal.AEBaseItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.qnb.QuantumRingBlock"): typeof Internal.QuantumRingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.LightSectionDebugRenderer"): typeof Internal.LightSectionDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalQuery"): Internal.TemporalQuery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack"): Internal.IWeaponAttack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.blocks.BlockRelay"): typeof Internal.BlockRelay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.waterwheel.LargeWaterWheelBlockEntity"): typeof Internal.LargeWaterWheelBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.model.quad.BakedQuadView"): Internal.BakedQuadView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Widget"): typeof dev.ftb.mods.ftblibrary.ui.Widget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.SimpleWeightedRandomList$Builder"): typeof Internal.SimpleWeightedRandomList$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.BeltSlope"): typeof Internal.BeltSlope;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.api.TransformType"): typeof Internal.TransformType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.lang.Appendable"): Internal.Appendable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.TropicalFish$Variant"): typeof Internal.TropicalFish$Variant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.config.ConfigBase"): typeof Internal.ConfigBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.PointerBuffer"): typeof Internal.PointerBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.HolderSet"): Internal.HolderSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.semaphore.SemaphoreBlock"): typeof Internal.SemaphoreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties"): typeof Internal.ModFluidRenderProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.GuiMessage"): typeof Internal.GuiMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.ModDataNBT"): typeof Internal.ModDataNBT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour"): typeof Internal.BeltProcessingBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGridNodeListener$State"): typeof Internal.IGridNodeListener$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.lib.registry.IVariantEntry"): Internal.IVariantEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundTagQueryPacket"): typeof Internal.ClientboundTagQueryPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.InterfaceLogic"): typeof Internal.InterfaceLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.property.PropertyParam"): typeof Internal.PropertyParam;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.event.registry.RegistryAttribute"): typeof Internal.RegistryAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.UnmodifiableCommentedConfig$CommentNode"): typeof Internal.UnmodifiableCommentedConfig$CommentNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LiquidBlockContainer"): Internal.LiquidBlockContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Iterator"): Internal.Iterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText$ContentConsumer"): Internal.FormattedText$ContentConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor"): net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.TheEndPortalBlockEntity"): typeof Internal.TheEndPortalBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor"): Internal.KeyBindingAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.EntityArrayList"): typeof Internal.EntityArrayList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.FieldAttributes"): typeof Internal.FieldAttributes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.advancement.CreateAdvancement"): typeof Internal.CreateAdvancement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.document.AbstractDocumentBase"): typeof Internal.AbstractDocumentBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.CustomStatBuilder"): typeof Internal.CustomStatBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.templates.TaggedChoice$TaggedChoiceType"): typeof Internal.TaggedChoice$TaggedChoiceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.SimplePlayerEventJS"): typeof Internal.SimplePlayerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.onyxstudios.cca.api.v3.entity.PlayerComponent"): Internal.PlayerComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity"): typeof Internal.SpeedGaugeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gantry.GantryShaftBlock$Part"): typeof Internal.GantryShaftBlock$Part;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jdk.internal.foreign.layout.ValueLayouts$OfShortImpl"): typeof Internal.ValueLayouts$OfShortImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BasePressurePlateBlock"): typeof Internal.BasePressurePlateBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Value"): typeof Internal.GameRules$Value;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.prestidigitation.InflatePufferfishEffect"): typeof Internal.InflatePufferfishEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.funnel.BeltFunnelBlock$Shape"): typeof Internal.BeltFunnelBlock$Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriBlockCondition$Builder"): typeof Internal.AgriBlockCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2IntFunction"): Internal.Reference2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockState"): typeof Internal.BlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalAmount"): Internal.TemporalAmount;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.fabric.SimpleFlowableFluid$Source"): typeof Internal.SimpleFlowableFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.charging.ChargingRecipe"): typeof Internal.ChargingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.IronPipeBlock"): typeof Internal.IronPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.util.ConfigManager"): typeof Internal.ConfigManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.AuthenticationService"): Internal.AuthenticationService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.GpuWarnlistManager"): typeof Internal.GpuWarnlistManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.networking.AbstractNetworkAddon"): typeof Internal.AbstractNetworkAddon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Cursor"): typeof Internal.Cursor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateBlockstateProvider"): typeof Internal.RegistrateBlockstateProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cc.abbie.emi_ores.mixin.accessor.RandomBlockStateMatchTestAccessor"): Internal.RandomBlockStateMatchTestAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainTools"): typeof Internal.TerrainTools;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.prestidigitation.CreeperEffect"): typeof Internal.CreeperEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure"): typeof Internal.ShipwreckStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.typings.desc.GenericDescJS"): typeof Internal.GenericDescJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryEventType"): typeof Internal.TelemetryEventType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity"): typeof Internal.PotatoProjectileEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SimpleRandomSelectorFeature"): typeof Internal.SimpleRandomSelectorFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec"): typeof Internal.ForgeConfigSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.createores.block.MultiblockPart$MultiblockMainPart$MultiblockPartType"): typeof Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.storage.SpatialStorageCellItem"): typeof Internal.SpatialStorageCellItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Scriptable"): Internal.Scriptable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.blocks.entity.BlockEntityMediafiedStorage$AnimationState"): typeof Internal.BlockEntityMediafiedStorage$AnimationState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$AbstractImmutableList"): typeof Internal.ImmutableCollections$AbstractImmutableList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket"): typeof Internal.ServerboundPlayerAbilitiesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.computer.terminal.TerminalState"): typeof Internal.TerminalState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.UniformInt"): typeof Internal.UniformInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.client.AccessorFontManager"): Internal.AccessorFontManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.api.casting.iota.MoteIota$1"): typeof Internal.MoteIota$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.alphamode.star.world.fluids.DirectionalFluid"): typeof Internal.DirectionalFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.world.structure.PixieVillageStructure"): typeof Internal.PixieVillageStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.CoralFeature"): typeof Internal.CoralFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.CrystalResonanceGeneratorBlock"): typeof Internal.CrystalResonanceGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.fluids.FluidType"): typeof Internal.FluidType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.state.CookingPotSupport"): typeof Internal.CookingPotSupport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jempasam.hexpigmentplus.recipe.HatShapedRecipe$Serializer"): typeof Internal.HatShapedRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.common.blocks.entity.BlockEntityRelay"): typeof Internal.BlockEntityRelay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Horizontal"): typeof Internal.WidgetLayout$Horizontal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.item.SlimelytraItem"): typeof Internal.SlimelytraItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$MarkerOrMarked"): Internal.DensityFunctions$MarkerOrMarked;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode"): typeof Internal.ToolSwapMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.entity.movement_tracker.EntityMovementTrackerSection"): Internal.EntityMovementTrackerSection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.util.nullness.NonNullConsumer"): com.tterrag.registrate.util.nullness.NonNullConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.HotCocoaItem"): typeof Internal.HotCocoaItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.CommonLevelAccessor"): Internal.CommonLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.world.structure.LargeJigsawStructure"): typeof Internal.LargeJigsawStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BrainDebugRenderer$PoiInfo"): typeof Internal.BrainDebugRenderer$PoiInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IHasCustomOutline"): Internal.IHasCustomOutline;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.font.TextAttribute"): typeof Internal.TextAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.EdgeLight"): typeof Internal.EdgeLight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ReflectionAccessFilter$FilterResult"): typeof Internal.ReflectionAccessFilter$FilterResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature"): typeof Internal.SlimeTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.ParticleStatus"): typeof Internal.ParticleStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket"): typeof Internal.ServerboundSetStructureBlockPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$11"): typeof Internal.ModBlocks$11;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.RandomAccess"): Internal.RandomAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.CapacityEnchantment"): typeof Internal.CapacityEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2ShortFunction"): Internal.Long2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ClipContext$Fluid"): typeof Internal.ClipContext$Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "link.infra.indium.renderer.accessor.AccessBlockModelRenderer"): Internal.AccessBlockModelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.VoidStartPlatformFeature"): typeof Internal.VoidStartPlatformFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlock"): typeof Internal.PostboxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BubbleColumnBlock"): typeof Internal.BubbleColumnBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.llamalad7.mixinextras.sugar.ref.LocalRef"): Internal.LocalRef;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.status.ServerStatus$Players"): typeof Internal.ServerStatus$Players;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockElementRotation"): typeof Internal.BlockElementRotation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.fluid.base.ItemFluidContainer"): Internal.ItemFluidContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.filter.PackageFilterItem"): typeof Internal.PackageFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongConsumer"): it.unimi.dsi.fastutil.longs.LongConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.loot.extensions.LootContextExtensions"): Internal.LootContextExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.animation.LerpedFloat"): typeof Internal.LerpedFloat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AttachedStemBlock"): typeof Internal.AttachedStemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry"): Internal.GameEventListenerRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.behaviour.display.DisplayTarget"): typeof Internal.DisplayTarget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.screen.ScreenAccessor"): net.fabricmc.fabric.mixin.screen.ScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.api.linkable.ILinkable$Companion"): typeof Internal.ILinkable$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeGrassBlock"): typeof Internal.SlimeGrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jempasam.hexpigmentplus.recipe.HatShapedRecipe$Type"): typeof Internal.HatShapedRecipe$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.SyncedBlockEntity"): typeof Internal.SyncedBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.MinecraftProfileTexture"): typeof Internal.MinecraftProfileTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.conductor_possession.AccessorKeyMapping"): com.railwayteam.railways.mixin.conductor_possession.AccessorKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BooleanComponent"): typeof Internal.BooleanComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.builder.ArgumentBuilder"): typeof Internal.ArgumentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe$Serializer"): typeof Internal.SeveringRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.api.lua.ILuaCallback"): Internal.ILuaCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer"): typeof Internal.GoalSelectorDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration"): typeof Internal.RandomFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.TextStyle"): typeof Internal.TextStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleList"): Internal.DoubleList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.OptionalInt"): typeof Internal.OptionalInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.GuiMessageTag$Icon"): typeof Internal.GuiMessageTag$Icon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.stream.LongStream$Builder"): Internal.LongStream$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ShulkerBoxBlock"): typeof Internal.ShulkerBoxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.worldgen.islands.EnderSlimeIslandStructure"): typeof Internal.EnderSlimeIslandStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.block.SeedAnalyzerBlock"): typeof Internal.SeedAnalyzerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.HugeLilyPadFeature"): typeof Internal.HugeLilyPadFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.common.item.DebuggerItem"): typeof Internal.DebuggerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.RandomTickCallbackJS"): typeof Internal.RandomTickCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.tree.BayouTreeFeature"): typeof Internal.BayouTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.mixin.accessor.AxeItemAccessor"): dev.emi.emi.mixin.accessor.AxeItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.GameProfileCache"): typeof Internal.GameProfileCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel"): Internal.FabricBakedModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidBlockBuilder"): typeof Internal.FluidBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.item.ItemColors"): typeof Internal.ItemColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem"): typeof Internal.AutoBlastingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalAccessor"): Internal.TemporalAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.arithmetic.operator.Operator$Companion"): typeof Internal.Operator$Companion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.ImageObserver"): Internal.ImageObserver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.burner.LitBlazeBurnerBlock"): typeof Internal.LitBlazeBurnerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.TimeOfDayDisplaySource"): typeof Internal.TimeOfDayDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.minecart.MinecartCouplingItem"): typeof Internal.MinecartCouplingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.items.ItemStaff"): typeof Internal.ItemStaff;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$RealmInfo"): typeof Internal.AbuseReportRequest$RealmInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.dispenser.DispenseItemBehavior"): Internal.DispenseItemBehavior;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.Animation$Composed"): typeof Internal.Animation$Composed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.depot.EjectorBlockEntity$State"): typeof Internal.EjectorBlockEntity$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.ModelGenerator$Element"): typeof Internal.ModelGenerator$Element;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.registry.ModRecipeTypes$1"): typeof vectorwing.farmersdelight.common.registry.ModRecipeTypes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.BonePipeBlock"): typeof Internal.BonePipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.smokestack.block.AxisSmokeStackBlock"): typeof Internal.AxisSmokeStackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeableHorseArmorItem"): typeof Internal.DyeableHorseArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.grid.AENetworkPowerBlockEntity"): typeof Internal.AENetworkPowerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.icon.IResourceIcon"): Internal.IResourceIcon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.elevator.ElevatorColumn$ColumnCoords"): typeof Internal.ElevatorColumn$ColumnCoords;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.core.fluid.ArchitecturyFluidAttributes"): Internal.ArchitecturyFluidAttributes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.items.ISpatialStorageCell"): Internal.ISpatialStorageCell;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$TargetPoint"): typeof Internal.Climate$TargetPoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.instance.InstanceType"): Internal.InstanceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Guard"): Internal.Guard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.computer.core.ServerComputer"): typeof Internal.ServerComputer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.HugeToadstoolFeature"): typeof Internal.HugeToadstoolFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.ControllerBlock"): typeof appeng.block.networking.ControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeProvider"): typeof Internal.RecipeProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.TinkersChestBlock"): typeof Internal.TinkersChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.AxolotlAttackablesSensor"): typeof Internal.AxolotlAttackablesSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeLeavesBlock"): typeof Internal.SlimeLeavesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.akashic.AkashicFloodfiller"): Internal.AkashicFloodfiller;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider$Rule"): typeof Internal.RuleBasedBlockStateProvider$Rule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.world.feature.SpawnDragonSkeleton"): typeof Internal.SpawnDragonSkeleton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundDisconnectPacket"): typeof Internal.ClientboundDisconnectPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.ExpandedMapData"): Internal.ExpandedMapData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo$Template"): typeof Internal.IntegerArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeWrapper"): typeof Internal.RefillUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.base.ConnectorVariant"): typeof Internal.ConnectorVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SignBlockEntity"): typeof Internal.SignBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.item.ModLabelItem"): typeof Internal.ModLabelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.PlayerChatDecorateEventJS"): typeof Internal.PlayerChatDecorateEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Squid"): typeof Internal.Squid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory"): typeof Internal.MainSettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.tropheusj.milk.MilkFluid"): typeof Internal.MilkFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.block.BeaconColorMultiplierBlock"): Internal.BeaconColorMultiplierBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.BogeySizes$BogeySize"): typeof Internal.BogeySizes$BogeySize;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.ItemTransformExtensions"): Internal.ItemTransformExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket"): typeof Internal.ClientboundSetBorderCenterPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.WorldOpenFlows"): typeof Internal.WorldOpenFlows;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.TinkersAnvilBlock"): typeof Internal.TinkersAnvilBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.AbuseReport"): typeof Internal.AbuseReport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterable"): Internal.LongIterable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemSeaSerpentArrow"): typeof Internal.ItemSeaSerpentArrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour$RequestType"): typeof Internal.LogisticallyLinkedBehaviour$RequestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.BigDecimal"): typeof Internal.BigDecimal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.iota.DoubleIota"): typeof Internal.DoubleIota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents$Visibility"): Internal.LivingEntityEvents$Visibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetObjectivePacket"): typeof Internal.ClientboundSetObjectivePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.armor.ItemSeaSerpentArmor"): typeof Internal.ItemSeaSerpentArmor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SpyglassItem"): typeof Internal.SpyglassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.Weight"): typeof Internal.Weight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.UserApiService$UserProperties"): typeof Internal.UserApiService$UserProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes$CampfireType"): typeof Internal.AllArmInteractionPointTypes$CampfireType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator"): Internal.IPassabilityNavigator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.saveddata.maps.MapItemSavedData$HoldingPlayer"): typeof Internal.MapItemSavedData$HoldingPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.core.util.Vec3d"): typeof Internal.Vec3d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriSoilVariant$Builder"): typeof Internal.AgriSoilVariant$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock"): typeof Internal.ElectricMotorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.WoodenFluidPipeBlock"): typeof Internal.WoodenFluidPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.ISerde"): Internal.ISerde;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.Remapper"): Internal.Remapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockBurntTorchWall"): typeof Internal.BlockBurntTorchWall;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.DataLayer"): typeof Internal.DataLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint$Mode"): typeof Internal.ArmInteractionPoint$Mode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.tool.extensions.VanillaToolActionItem"): Internal.VanillaToolActionItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.EndRodBlock"): typeof Internal.EndRodBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.AbstractIllager$IllagerArmPose"): typeof Internal.AbstractIllager$IllagerArmPose;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.extensions.pocketpiston.LivingEntityExtensions"): Internal.LivingEntityExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visualization.VisualizationContext"): Internal.VisualizationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator"): typeof Internal.TreeDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Registry"): Internal.Registry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.ThinLamp"): typeof Internal.ThinLamp;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.mixin.util.entity_movement_tracking.ServerEntityManagerAccessor"): me.jellysquid.mods.lithium.mixin.util.entity_movement_tracking.ServerEntityManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainer$Configuration"): typeof Internal.PalettedContainer$Configuration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.ScheduledEvents"): typeof Internal.ScheduledEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Zombie"): typeof Internal.Zombie;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "miyucomics.hexical.prestidigitation.DeprimeTntEffect"): typeof Internal.DeprimeTntEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour"): typeof Internal.FilteringBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerEntityManagerAccessor"): Internal.ServerEntityManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.storage.SkyChestBlock$SkyChestType"): typeof Internal.SkyChestBlock$SkyChestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.WorldDownload"): typeof Internal.WorldDownload;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.SingleAxleBogeyBlock"): typeof Internal.SingleAxleBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.raid.Raids"): typeof Internal.Raids;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.BasicItemJS$Builder"): typeof Internal.BasicItemJS$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker"): Internal.ISlotTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.SoundEngine"): typeof Internal.SoundEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature"): typeof Internal.AbstractHugeMushroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BundleItemAccessor"): Internal.BundleItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor"): com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.fabric.xplat.FabricItemRelay"): typeof Internal.FabricItemRelay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.fertilizer.AgriFertilizerVariant"): typeof Internal.AgriFertilizerVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.ReputationEventType"): Internal.ReputationEventType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EventListener"): Internal.EventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundLoginPacket"): typeof Internal.ClientboundLoginPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem"): Internal.IAutoCookingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.BasicMobEffect$Builder"): typeof Internal.BasicMobEffect$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.bell.HauntedBellBlock"): typeof Internal.HauntedBellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.item.BiomassPelletBlock"): typeof Internal.BiomassPelletBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallBlock"): typeof Internal.WallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.StatsCounter"): typeof Internal.StatsCounter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.moreiotas.api.casting.iota.IotaTypeIota"): typeof Internal.IotaTypeIota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.fabric.ItemRendererAccessor"): net.mehvahdjukaar.moonlight.core.mixins.fabric.ItemRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2DoubleFunction"): Internal.Float2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriBlockCondition"): typeof Internal.AgriBlockCondition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.gui.extensions.GuiGraphicsExtension"): Internal.GuiGraphicsExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.compat.jei.category.sequencedAssembly.JeiSequencedAssemblySubCategory"): typeof Internal.JeiSequencedAssemblySubCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.Table"): Internal.Table;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer"): typeof Internal.ForkingTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement"): typeof Internal.RandomSpreadStructurePlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.FullChunkStatus"): typeof Internal.FullChunkStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.DistanceManager"): typeof Internal.DistanceManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockElementFace"): typeof Internal.BlockElementFace;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.iota.EntityIota$1"): typeof Internal.EntityIota$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.api.turtle.ITurtleAccess"): Internal.ITurtleAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.press.PressingBehaviour$PressingBehaviourSpecifics"): Internal.PressingBehaviour$PressingBehaviourSpecifics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.energy.WireType"): typeof Internal.WireType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade"): Internal.ISlotLimitUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.SpriteLoader$Preparations"): typeof Internal.SpriteLoader$Preparations;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.network.AbstractPacket"): typeof Internal.AbstractPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.Window"): typeof com.mojang.blaze3d.platform.Window;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.fabric.ParticleEngineAccessor"): Internal.ParticleEngineAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.BacktankItem"): typeof Internal.BacktankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.core.metrics.MetricsObserver"): Internal.MetricsObserver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.ingredient.FluidIngredient$Serializer"): typeof Internal.FluidIngredient$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BlockLootSubProviderAccessor"): Internal.BlockLootSubProviderAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents"): typeof Internal.EntityEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode"): typeof Internal.RepeatMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.BiomeFilter"): typeof net.minecraft.world.level.levelgen.placement.BiomeFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.world.blockentity.BlockEntityGetter"): Internal.BlockEntityGetter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.block.IHaveBigOutline"): Internal.IHaveBigOutline;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$Enum"): typeof Internal.OptionInstance$Enum;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.BeltBlockEntity"): typeof Internal.BeltBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Permission"): typeof Internal.Permission;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents$BeforeKeyRelease"): Internal.ScreenKeyboardEvents$BeforeKeyRelease;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.LargeConnectorBlockEntity"): typeof Internal.LargeConnectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe"): typeof Internal.ModifierRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade"): Internal.IBlockToolSwapUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.OwoUIDrawContext$TextAnchor"): typeof Internal.OwoUIDrawContext$TextAnchor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemAmphithereArrow"): typeof Internal.ItemAmphithereArrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType"): typeof Internal.FeatureSizeType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.render.ContraptionMatrices"): typeof Internal.ContraptionMatrices;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.computer.items.IComputerItem"): Internal.IComputerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.HandheldItemBuilder"): typeof Internal.HandheldItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeTallGrassBlock"): typeof Internal.SlimeTallGrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.ControllerBlock$ControllerBlockState"): typeof Internal.ControllerBlock$ControllerBlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.modifiers.ModifierHook"): typeof Internal.ModifierHook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.extensions.item.SophisticatedItem"): Internal.SophisticatedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration"): typeof Internal.RandomPatchConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.WeightedListInt"): typeof Internal.WeightedListInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateItemModelProvider"): typeof Internal.RegistrateItemModelProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.EquipmentSlot"): typeof Internal.EquipmentSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier"): typeof Internal.AbstractModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HighGrassPlantBlock"): typeof Internal.HighGrassPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.base.event.ArrayBackedEvent"): typeof Internal.ArrayBackedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlockEntityType"): typeof Internal.BlockEntityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleComponent"): Internal.AccessibleComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.arsenal.item.ArsenalWeaponItem"): Internal.ArsenalWeaponItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CaveVinesBlock"): typeof Internal.CaveVinesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.ChunkLoaderBlock"): typeof Internal.ChunkLoaderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock"): typeof Internal.MechanicalCrafterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundClientCommandPacket"): typeof Internal.ServerboundClientCommandPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.crafting.IPatternDetails"): Internal.IPatternDetails;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents$XpChange"): typeof Internal.PlayerEvents$XpChange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.response.Response"): typeof Internal.Response;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.functions.LootItemFunction"): Internal.LootItemFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.gadgets.item.slimesling.IchorSlimeSlingItem"): typeof Internal.IchorSlimeSlingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.AdvancedCopperPipeBlock"): typeof Internal.AdvancedCopperPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.TrackBlock"): typeof Internal.TrackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState"): typeof Internal.DiskDriveState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HangingCobwebBottomBlock"): typeof Internal.HangingCobwebBottomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockLectern"): typeof Internal.BlockLectern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.necklace.PendantItem"): typeof Internal.PendantItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.goal.Goal$Flag"): typeof Internal.Goal$Flag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.media.items.TreasureDiskItem"): typeof Internal.TreasureDiskItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.onyxstudios.cca.internal.item.ItemCaller"): Internal.ItemCaller;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamProperty"): typeof Internal.TeamProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.fabric.MenuTypeAccessor"): Internal.MenuTypeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.walksanator.hextweaks.casting.iota.ByteArrayIota"): typeof Internal.ByteArrayIota;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.CustomEnchantmentsItem"): Internal.CustomEnchantmentsItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemTransforms"): typeof Internal.ItemTransforms;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.IdScriptableObject"): typeof Internal.IdScriptableObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket"): typeof Internal.ClientboundBlockChangedAckPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TooltipFlag$Default"): typeof Internal.TooltipFlag$Default;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.ItemDragonScales"): typeof Internal.ItemDragonScales;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignableCommand$Argument"): typeof Internal.SignableCommand$Argument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationController$State"): typeof Internal.AnimationController$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder"): typeof Internal.FabricRegistryBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.loader.AtlasPBRLoader$PBRTextureAtlasSprite"): typeof Internal.AtlasPBRLoader$PBRTextureAtlasSprite;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.ReflectionBasedSerialization"): Internal.ReflectionBasedSerialization;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents"): typeof Internal.LivingEntityEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.periut.factoryblocks.block.fan.MediumFanBlock"): typeof Internal.MediumFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.font.glyphs.BakedGlyph"): typeof Internal.BakedGlyph;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Button"): typeof dev.ftb.mods.ftblibrary.ui.Button;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.HopperBlockEntity"): typeof Internal.HopperBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.ObsidianPipeBlock"): typeof Internal.ObsidianPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.AgeableListModel"): typeof Internal.AgeableListModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.genetic.AgriGenePair"): typeof Internal.AgriGenePair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BeehiveBlockEntity$BeeReleaseStatus"): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.zone.ZoneRules"): typeof Internal.ZoneRules;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EventObject"): typeof Internal.EventObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.ClickEvent"): typeof Internal.ClickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour$StepContext"): typeof Internal.ScrollValueBehaviour$StepContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.DebugQueryHandler"): typeof Internal.DebugQueryHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.DamageableItem"): Internal.DamageableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe"): typeof Internal.ItemCastingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.GameNarrator"): typeof Internal.GameNarrator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.net.NetworkEventJS"): typeof Internal.NetworkEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes$FunnelType"): typeof Internal.AllArmInteractionPointTypes$FunnelType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.object.builder.AbstractBlockSettingsAccessor"): Internal.AbstractBlockSettingsAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.LivingEntity$Fallsounds"): typeof Internal.LivingEntity$Fallsounds;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.MilkBucketItem"): typeof Internal.MilkBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.BaseArmorItem"): typeof Internal.BaseArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer"): typeof Internal.AcaciaFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P9"): typeof Internal.Products$P9;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket"): typeof Internal.ClientboundChunksBiomesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.HighGrassBlock"): typeof Internal.HighGrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.flanks255.simplylight.blocks.BaseBlockItem"): typeof Internal.BaseBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.container.ISingleStackContainer"): Internal.ISingleStackContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector2i"): typeof Internal.Vector2i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.switches.TrackSwitchBlock$SwitchConstraint"): typeof Internal.TrackSwitchBlock$SwitchConstraint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions"): Internal.IDisplayAssemblyExceptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry$Wrapper"): typeof Internal.WeightedEntry$Wrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.headstock.HeadstockStyle"): typeof Internal.HeadstockStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.agricraft.agricraft.api.codecs.AgriSeed"): typeof Internal.AgriSeed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BasicBackpackRecipe$Serializer"): typeof Internal.BasicBackpackRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$SetN"): typeof Internal.ImmutableCollections$SetN;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.OptionalDouble"): typeof Internal.OptionalDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.emi.emi.api.widget.DrawableWidget$DrawableWidgetConsumer"): Internal.DrawableWidget$DrawableWidgetConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.gui.AllIcons"): typeof Internal.AllIcons;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BrewingStandBlock"): typeof Internal.BrewingStandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenIronFluid"): typeof Internal.MoltenIronFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder"): typeof Internal.InventoryOrder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.util.LazySpawnEggItem"): typeof Internal.LazySpawnEggItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler$ThresholdTest"): Internal.MetricSampler$ThresholdTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.EndTag"): typeof Internal.EndTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.observer.TrackObserverBlock"): typeof Internal.TrackObserverBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.animations.tracking.SpriteContentsAnimationFrameAccessor"): me.jellysquid.mods.sodium.mixin.features.textures.animations.tracking.SpriteContentsAnimationFrameAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix2dc"): Internal.Matrix2dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe$Serializer"): typeof Internal.ShapedRetexturedRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.ModifierNBT$Builder"): typeof Internal.ModifierNBT$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.BloodFluid$Source"): typeof Internal.BloodFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenElectrumFluid$Source"): typeof Internal.MoltenElectrumFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ComponentRole"): typeof Internal.ComponentRole;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.armor.ItemTrollArmor"): typeof Internal.ItemTrollArmor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenMetalFluid"): typeof Internal.MoltenMetalFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ConfigGroup"): typeof Internal.ConfigGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup$GroupedBlock"): Internal.BlockStateBlockItemGroup$GroupedBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.item.UraniniteItem"): typeof Internal.UraniniteItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.NativeResource"): Internal.NativeResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.AttributeSet$ColorAttribute"): Internal.AttributeSet$ColorAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.builders.MenuBuilder$ScreenFactory"): Internal.MenuBuilder$ScreenFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.misc.QuartzFixtureBlock"): typeof Internal.QuartzFixtureBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.input.MouseButton"): typeof Internal.MouseButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.SmartBlockEntity"): typeof Internal.SmartBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.IMouseWheelItem"): Internal.IMouseWheelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.RecordBuilder"): Internal.RecordBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.synth.BlendedNoise"): typeof Internal.BlendedNoise;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder"): typeof Internal.SlabBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundEntityTagQuery"): typeof Internal.ServerboundEntityTagQuery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection"): typeof Internal.FactoryPanelConnection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.util.nullness.NonNullBiFunction"): Internal.NonNullBiFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationInfo"): typeof Internal.VibrationInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockFaceUV"): typeof Internal.BlockFaceUV;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DropTargetContext"): typeof Internal.DropTargetContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Quaterniond"): typeof Internal.Quaterniond;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TrapDoorBlock"): typeof Internal.TrapDoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener"): Internal.InventoryChangeListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.GeodeLayerSettings"): typeof Internal.GeodeLayerSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.ClientRecipeBook"): typeof Internal.ClientRecipeBook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.entity.EntityPersistentStorage"): Internal.EntityPersistentStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignedMessageValidator"): Internal.SignedMessageValidator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.AWTEvent"): typeof Internal.AWTEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.eval.ResolvedPatternType"): typeof Internal.ResolvedPatternType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic"): typeof Internal.ContentsFilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType"): Internal.RuleTestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapLike"): Internal.MapLike;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.PlayerInfo"): typeof com.mojang.realmsclient.dto.PlayerInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Frame"): typeof Internal.Frame;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.SandyShrubBlock"): typeof Internal.SandyShrubBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.networking.SimplePacketBase$NetworkDirection"): typeof Internal.SimplePacketBase$NetworkDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongBidirectionalIterator"): Internal.LongBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager"): Internal.FabricBakedModelManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.hexal.api.mediafieditems.MediafiedItemManager$Index"): typeof Internal.MediafiedItemManager$Index;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate"): typeof Internal.AnyOfPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$TooltipSupplier"): Internal.OptionInstance$TooltipSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenNecromiumFluid"): typeof Internal.MoltenNecromiumFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.table.SchematicTableBlockEntity$SchematicTableInventory"): typeof Internal.SchematicTableBlockEntity$SchematicTableInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType"): Internal.RecipeType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type$TypeError"): typeof Internal.Type$TypeError;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity"): typeof Internal.EnchantmentTableBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer"): typeof Internal.SequencedAssemblyRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.alphamode.star.extensions.fabric.FluidRenderHandlerExtension"): Internal.FluidRenderHandlerExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.arguments.StringArgumentType"): typeof Internal.StringArgumentType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.EyeOfEnder"): typeof Internal.EyeOfEnder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BaseContainerBlockEntity"): typeof Internal.BaseContainerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.base.DirectionalShaftHalvesBlockEntity"): typeof Internal.DirectionalShaftHalvesBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.PacketSendListener"): Internal.PacketSendListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.SpellList$SpellListIterator"): typeof Internal.SpellList$SpellListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.definition.ToolDefinition$Builder"): typeof Internal.ToolDefinition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.bracket.BracketBlock$BracketType"): typeof Internal.BracketBlock$BracketType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ExclusionStrategy"): Internal.ExclusionStrategy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.LevelTickAccess"): Internal.LevelTickAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.NullLeavesBlock"): typeof Internal.NullLeavesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.TextureStateShardAccessor"): Internal.TextureStateShardAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlock"): typeof Internal.RedstoneRelayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer"): Internal.ITinkerStationContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpikeFeature"): typeof Internal.SpikeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceKeyArgument"): typeof Internal.ResourceKeyArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeSpecialEffects"): typeof Internal.BiomeSpecialEffects;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "owmii.powah.api.energy.endernetwork.IEnderExtender"): Internal.IEnderExtender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.ordana.molten_metals.fluids.MoltenCopperFluid$Source"): typeof Internal.MoltenCopperFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.bell.PeculiarBellBlockEntity"): typeof Internal.PeculiarBellBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior"): Internal.DynamicLightBehavior;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.MonsterRoomFeature"): typeof Internal.MonsterRoomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.box.PackageItem"): typeof Internal.PackageItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.LevelChunk$PostLoadProcessor"): Internal.LevelChunk$PostLoadProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ClampedInt"): typeof Internal.ClampedInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.item.ModifiableCrossbowItem"): typeof Internal.ModifiableCrossbowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.valve.FluidValveBlockEntity"): typeof Internal.FluidValveBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.fabric.TagAppenderAccessor"): Internal.TagAppenderAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.ScheduledEvents$ScheduledEvent"): typeof Internal.ScheduledEvents$ScheduledEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.ComponentOrientation"): typeof Internal.ComponentOrientation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleRelationSet"): typeof Internal.AccessibleRelationSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WitherWallSkullBlock"): typeof Internal.WitherWallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Creeper"): typeof Internal.Creeper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPickItemPacket"): typeof Internal.ServerboundPickItemPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.LevelRenderer"): typeof Internal.LevelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.DeathMessageType"): typeof Internal.DeathMessageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.AbstractButton"): typeof Internal.AbstractButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleSpliterator"): Internal.DoubleSpliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.CustomJavaToJsWrapper"): Internal.CustomJavaToJsWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.MobEffectItem"): typeof Internal.MobEffectItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection"): Internal.TeamPropertyCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Widget$DrawLayer"): typeof Internal.Widget$DrawLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.periut.factoryblocks.block.BaseFactoryBlock"): typeof Internal.BaseFactoryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.ComponentEvent"): typeof Internal.ComponentEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cc.abbie.emi_ores.mixin.accessor.HeightRangePlacementAccessor"): Internal.HeightRangePlacementAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.ModelBakery$BakedCacheKey"): typeof Internal.ModelBakery$BakedCacheKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimatableManager"): typeof Internal.AnimatableManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.spectrelib.mixin.SpectreLibMixinLevelResource"): Internal.SpectreLibMixinLevelResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundClearTitlesPacket"): typeof Internal.ClientboundClearTitlesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.storage.SkyChestBlock"): typeof Internal.SkyChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe$Serializer"): typeof Internal.EntityMeltingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.ValueListDisplaySource"): typeof Internal.ValueListDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_texture_features.features.texture_handlers.ETFTexture"): typeof Internal.ETFTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.doctor4t.arsenal.entity.AnchorbladeEntity"): typeof Internal.AnchorbladeEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlockEntity"): typeof Internal.InvisibleMonoBogeyBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.MessageSenderKJS"): Internal.MessageSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Direction"): typeof Internal.Direction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.FireworkRocketEntityKJS"): Internal.FireworkRocketEntityKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.item.RetexturedBlockItem"): typeof Internal.RetexturedBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ram.talia.moreiotas.api.casting.iota.ItemStackIota$1"): typeof Internal.ItemStackIota$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.Resource"): typeof Internal.Resource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.TextureSheetParticleAccessor"): Internal.TextureSheetParticleAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ChestLootEventJS"): typeof Internal.ChestLootEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.gadgets.block.FoodCakeBlock"): typeof Internal.FoodCakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer$Fluid"): Internal.IMultiBlockEntityContainer$Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts"): typeof Internal.PackageOrderWithCrafts;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.ConfigSpec$CorrectionListener"): Internal.ConfigSpec$CorrectionListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.head.NightVisionGogglesItem"): typeof Internal.NightVisionGogglesItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.im.InputMethodHighlight"): typeof Internal.InputMethodHighlight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.BlastFurnaceMenu"): typeof Internal.BlastFurnaceMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRecipePacket"): typeof Internal.ClientboundRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$FloatInterpolator"): Internal.Display$FloatInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AmethystBlock"): typeof Internal.AmethystBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.raphimc.immediatelyfast.injection.interfaces.IMapRenderer"): Internal.IMapRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.block.WildflowerBlock"): typeof Internal.WildflowerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.api.upgrades.UpgradeData"): typeof dan200.computercraft.api.upgrades.UpgradeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.burner.BlazeBurnerBlock$HeatLevel"): typeof Internal.BlazeBurnerBlock$HeatLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.systems.RenderSystem$AutoStorageIndexBuffer"): typeof Internal.RenderSystem$AutoStorageIndexBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.tool.ItemTideTrident"): typeof Internal.ItemTideTrident;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.properties.Property"): typeof com.mojang.authlib.properties.Property;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.hands.OnionRingItem"): typeof Internal.OnionRingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.fabric.AbstractContainerScreenAccessor"): com.simibubi.create.foundation.mixin.fabric.AbstractContainerScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock"): typeof Internal.PortableEnergyInterfaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.level.biome.BiomeModifications$BiomeContext"): Internal.BiomeModifications$BiomeContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.BuiltInExceptionProvider"): Internal.BuiltInExceptionProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainerRO"): Internal.PalettedContainerRO;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder"): Internal.SpriteFinder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.glue.SuperGlueItem"): typeof Internal.SuperGlueItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.wispforest.owo.ui.core.CursorStyle"): typeof Internal.CursorStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BlockEntityAccessor"): Internal.BlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragSourceDropEvent"): typeof Internal.DragSourceDropEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BeeDebugRenderer$BeeInfo"): typeof Internal.BeeDebugRenderer$BeeInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock"): typeof Internal.PoweredShaftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$RenderState"): typeof Internal.Display$RenderState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.ItemFrame"): typeof Internal.ItemFrame;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock"): typeof Internal.ChainDriveBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fuzs.forgeconfigapiport.mixin.accessor.LevelResourceAccessor"): Internal.LevelResourceAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.materials.EnergyCardItem"): typeof Internal.EnergyCardItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.clock.CuckooClockBlock"): typeof Internal.CuckooClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.eval.vm.FrameForEach$Companion$TYPE$1"): typeof Internal.FrameForEach$Companion$TYPE$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.BaseSpawner"): typeof Internal.BaseSpawner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.loot.LootTableProvider$SubProviderEntry"): typeof Internal.LootTableProvider$SubProviderEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.StringRepresentable$EnumCodec"): typeof Internal.StringRepresentable$EnumCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainer$CountConsumer"): Internal.PalettedContainer$CountConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.modernfix.duck.IBlockState"): Internal.IBlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToDoubleFunction"): Internal.LongToDoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL"): Internal.DisplayInfoFTBL;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StandingSignBlock"): typeof Internal.StandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate"): typeof Internal.ReplaceablePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.impl.IUpperPartHelper"): Internal.IUpperPartHelper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.View"): typeof Internal.View;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.botarium.common.fluid.base.FluidSnapshot"): Internal.FluidSnapshot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.block.NeighborChangeListeningBlock"): Internal.NeighborChangeListeningBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PaintContext"): Internal.PaintContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorBlock"): typeof Internal.EntityDetectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.builders.CubeDefinition"): typeof Internal.CubeDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.renderer.client.BakedModelMixin"): Internal.BakedModelMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType$1"): typeof Internal.RecipeType$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.adastra.common.registry.ModBlocks$3"): typeof Internal.ModBlocks$3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyValue"): typeof Internal.TeamPropertyValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe"): Internal.IModifierRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.polymorph.mixin.core.AccessorAbstractContainerScreen"): Internal.AccessorAbstractContainerScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.Format$Field"): typeof Internal.Format$Field;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.alphamode.star.world.fluids.TestFluid"): typeof Internal.TestFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration"): typeof Internal.CaveCarverConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.geom.AffineTransform"): typeof Internal.AffineTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity"): typeof Internal.SimpleKineticBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Tier"): Internal.Tier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.api.upgrades.UpgradeSerialiser"): Internal.UpgradeSerialiser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Direction8"): typeof Internal.Direction8;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CrossCollisionBlock"): typeof Internal.CrossCollisionBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.infrastructure.worldgen.LayerPattern"): typeof Internal.LayerPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BlockStateProperties"): typeof BlockProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$OutputStateShard"): typeof Internal.RenderStateShard$OutputStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Decoder$Terminal"): Internal.Decoder$Terminal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.hooks.IntrinsicEnchantItem"): Internal.IntrinsicEnchantItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.LakeFeature$Configuration"): typeof Internal.LakeFeature$Configuration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock"): typeof Internal.BeltTunnelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BlockItem"): typeof Internal.BlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.Transferable"): Internal.Transferable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.AlgorithmParameters"): typeof Internal.AlgorithmParameters;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.SculkSensorPhase"): typeof Internal.SculkSensorPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$DamageBonusFunction"): Internal.EnchantmentBuilder$DamageBonusFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.CragSplatterFeature"): typeof Internal.CragSplatterFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.EntryDisplayState"): typeof Internal.EntryDisplayState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock$PistonState"): typeof Internal.MechanicalPistonBlock$PistonState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldDimensions"): typeof Internal.WorldDimensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry"): Internal.WeightedEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.ParticleExtensions"): Internal.ParticleExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.BlockStateBlockItem"): typeof Internal.BlockStateBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.ReportedEntity"): typeof Internal.ReportedEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator$Pack$Factory"): Internal.FabricDataGenerator$Pack$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootParams"): typeof Internal.LootParams;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packager.PackagerBlockEntity"): typeof Internal.PackagerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.SignatureUpdater"): Internal.SignatureUpdater;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SkullBlockEntity"): typeof Internal.SkullBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.behaviour.movement.MovementBehaviour"): Internal.MovementBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.core.computer.ComputerEnvironment"): Internal.ComputerEnvironment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dan200.computercraft.shared.common.IColouredItem"): Internal.IColouredItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SignApplicator"): Internal.SignApplicator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.unit.Unit"): typeof Internal.Unit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType"): typeof Internal.Dynamic2CommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents$AfterMouseScroll"): Internal.ScreenMouseEvents$AfterMouseScroll;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.GrassSplatterFeature"): typeof Internal.GrassSplatterFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity$FuelType"): typeof Internal.LiquidBlazeBurnerBlockEntity$FuelType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.slidingDoor.DoorControl"): typeof Internal.DoorControl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallSkullBlock"): typeof Internal.WallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.DataFlavor"): typeof Internal.DataFlavor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryPropertyMap$Builder"): typeof Internal.TelemetryPropertyMap$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.Commands$CommandSelection"): typeof Internal.Commands$CommandSelection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.OwnableEntity"): Internal.OwnableEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement"): typeof Internal.RandomOffsetPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.Model"): typeof Internal.Model;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jagm.classicpipes.block.RecipePipeBlock"): typeof Internal.RecipePipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.zestyblaze.lootr.block.LootrShulkerBlock"): typeof Internal.LootrShulkerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.unit.MutableNumberUnit"): typeof Internal.MutableNumberUnit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animatable.model.CoreGeoBone"): Internal.CoreGeoBone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.fabric.MappedRegistryAccessor"): Internal.MappedRegistryAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.common.blocks.decoration.BlockHexDoor"): typeof Internal.BlockHexDoor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Collections$UnmodifiableCollection"): typeof Internal.Collections$UnmodifiableCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.entity.extensions.PlayerExtension"): Internal.PlayerExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.property.AbstractProperty"): typeof Internal.AbstractProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.ICraftingPlan"): Internal.ICraftingPlan;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.impl.lookup.block.ServerWorldCache"): Internal.ServerWorldCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.block.BlockDreadSlab"): typeof Internal.BlockDreadSlab;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.item.TinkersChestBlockItem"): typeof Internal.TinkersChestBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.misc.FallenJacarandaLogFeature"): typeof Internal.FallenJacarandaLogFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.core.item.ArchitecturySpawnEggItem"): typeof Internal.ArchitecturySpawnEggItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.BooleanUnaryOperator"): Internal.BooleanUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.ICogWheel"): Internal.ICogWheel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SlimeBlock"): typeof Internal.SlimeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket"): typeof Internal.ClientboundCustomChatCompletionsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.AWTKeyStroke"): typeof Internal.AWTKeyStroke;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packager.PackagerBlock"): typeof Internal.PackagerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.sniffer.Sniffer"): typeof Internal.Sniffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant"): Internal.FluidVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.renderer.v1.material.MaterialView"): Internal.MaterialView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus"): typeof Internal.BlockEntityAbstractImpetus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.toasts.Toast"): Internal.Toast;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate"): typeof Internal.TrueBlockPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter"): typeof Internal.SurfaceWaterDepthFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SortedSet"): Internal.SortedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.fluids.DirectionalSlimeFluid"): typeof Internal.DirectionalSlimeFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration"): typeof Internal.TreeConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenEvents$AfterTick"): Internal.ScreenEvents$AfterTick;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.FactoryGaugeDisplaySource"): typeof Internal.FactoryGaugeDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.tank.FluidTankItem"): typeof Internal.FluidTankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TridentItem"): typeof Internal.TridentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeableArmorItem"): typeof Internal.DyeableArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.cache.LoadingCache"): Internal.LoadingCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Event"): typeof Internal.Event;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BambooStalkBlock"): typeof Internal.BambooStalkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.lithium.common.hopper.UpdateReceiver"): Internal.UpdateReceiver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.worldgen.feature.tree.BushTreeFeature"): typeof Internal.BushTreeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.worldgen.trees.feature.SlimeFungusFeature"): typeof Internal.SlimeFungusFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PointedDripstoneBlock$FluidInfo"): typeof Internal.PointedDripstoneBlock$FluidInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.MultiBufferSource$BufferSource"): typeof Internal.MultiBufferSource$BufferSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.ChronoLocalDate"): Internal.ChronoLocalDate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationState"): typeof software.bernie.geckolib.core.animation.AnimationState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.world.BiomeSeedProvider"): Internal.BiomeSeedProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.instance.InstanceHandle"): Internal.InstanceHandle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.drill.DrillBlockEntity"): typeof Internal.DrillBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.FireworkRocketEntity"): typeof Internal.FireworkRocketEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.inline.mixin.feature.playerskins.MixinAccessPlayerModelParts"): Internal.MixinAccessPlayerModelParts;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.lambdaurora.spruceui.option.SpruceOption"): typeof Internal.SpruceOption;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.ReportEnvironment"): typeof Internal.ReportEnvironment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SnowyDirtBlock"): typeof Internal.SnowyDirtBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "gripe._90.polyeng.mixin.AbstractContainerScreenAccessor"): gripe._90.polyeng.mixin.AbstractContainerScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.SweepingEdgeEnchantment"): typeof Internal.SweepingEdgeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration"): typeof Internal.PointedDripstoneConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.transfer.BucketItemAccessor"): net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "jdk.internal.foreign.MemorySessionImpl"): typeof Internal.MemorySessionImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.ClassWrapper"): typeof Internal.ClassWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.particle.DragonParticleType"): typeof Internal.DragonParticleType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.ItemGenBlock"): typeof Internal.ItemGenBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock"): typeof Internal.SteamEngineBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockModel"): typeof Internal.BlockModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.smokestack.block.SmokeStackBlock"): typeof Internal.SmokeStackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.font.GlyphProvider"): Internal.GlyphProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.RedirectModifier"): Internal.RedirectModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.fluids.DirectionalSlimeFluid$Flowing"): typeof Internal.DirectionalSlimeFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.comforts.common.block.RopeAndNailBlock"): typeof Internal.RopeAndNailBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.pathfinder.NodeEvaluator"): typeof Internal.NodeEvaluator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.WaterWalkerEnchantment"): typeof Internal.WaterWalkerEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.IsInWaterSensor"): typeof Internal.IsInWaterSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.render.model.util.LegSolver$Leg"): typeof Internal.LegSolver$Leg;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SandBlock"): typeof Internal.SandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendStatic"): typeof Internal.AppendStatic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ItemRendererAccessor"): io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ItemRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes"): Internal.IHasCustomizableAttributes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.LazyComponentKJS"): Internal.LazyComponentKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.Duration"): typeof Duration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.PlayerTeam"): typeof Internal.PlayerTeam;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.Tristate"): typeof Internal.Tristate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.ScriptableObject"): typeof Internal.ScriptableObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlock"): typeof Internal.SculkophoneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P15"): typeof Internal.Products$P15;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableMultimap"): typeof Internal.ImmutableMultimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.Visual"): Internal.Visual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FlowerPotBlock"): typeof Internal.FlowerPotBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.recipe.ingredient.FluidIngredient$Empty"): typeof Internal.FluidIngredient$Empty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.BlockContainerJS"): typeof Internal.BlockContainerJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.nio.ByteOrder"): typeof Internal.ByteOrder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.DamageEnchantment"): typeof Internal.DamageEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.crusher.CrushingWheelBlock"): typeof Internal.CrushingWheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.item.v1.CustomDamageHandler"): Internal.CustomDamageHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Illusioner"): typeof Internal.Illusioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.UpgradeData"): typeof Internal.UpgradeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LightBlock"): typeof Internal.LightBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PointedDripstoneBlock"): typeof Internal.PointedDripstoneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.digital_adapter.ISpeedControllerAdapter"): Internal.ISpeedControllerAdapter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity"): typeof Internal.SequencedGearshiftBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapCodec$ResultFunction"): Internal.MapCodec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.VegetationPatchFeature"): typeof Internal.VegetationPatchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.extensions.extensions.StructureTemplateExtensions"): Internal.StructureTemplateExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.item.api.itemgroup.PortingLibCreativeTab$TabData"): typeof Internal.PortingLibCreativeTab$TabData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerFunctionManager"): typeof Internal.ServerFunctionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.head.SnorkelItem"): typeof Internal.SnorkelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryProperty$GameMode"): typeof Internal.TelemetryProperty$GameMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.DataVersion"): typeof Internal.DataVersion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.piglin.PiglinArmPose"): typeof Internal.PiglinArmPose;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents$AfterKeyRelease"): Internal.ScreenKeyboardEvents$AfterKeyRelease;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ArgumentSignatures"): typeof Internal.ArgumentSignatures;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.fabricmc.fabric.mixin.content.registry.VillagerEntityAccessor"): Internal.VillagerEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.fuel.tank.FuelTankItem"): typeof Internal.FuelTankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.iafenvoy.iceandfire.item.armor.ItemBlindfold"): typeof Internal.ItemBlindfold;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetTimePacket"): typeof Internal.ClientboundSetTimePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.fabricators_of_create.porting_lib.transfer.internal.cache.ClientBlockApiCache"): Internal.ClientBlockApiCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.EntitySteppedOnBlockCallbackJS"): typeof Internal.EntitySteppedOnBlockCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.builders.LayerDefinition"): typeof Internal.LayerDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.AttributeValue"): typeof Internal.AttributeValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.display.FlapDisplayBlock"): typeof Internal.FlapDisplayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.EnergyCellBlock"): typeof appeng.block.networking.EnergyCellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CropBlock"): typeof Internal.CropBlock;
        /**
         * Loads the specified class, and throws error if cl